/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.ClientPluginDeployer;
import org.hyperic.hq.product.GenericPlugin;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.ScriptLanguagePlugin;
import org.hyperic.hq.product.TypeInfo;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public abstract class ProductPlugin
extends GenericPlugin {
    public static final String TYPE_AUTOINVENTORY = "autoinventory";
    public static final String TYPE_CONTROL = "control";
    public static final String TYPE_MEASUREMENT = "measurement";
    public static final String TYPE_PRODUCT = "product";
    public static final String TYPE_RESPONSE_TIME = "responsetime";
    public static final String TYPE_LOG_TRACK = "log_track";
    public static final String TYPE_LIVE_DATA = "livedata";
    public static final String PROP_INSTALLPATH = "installpath";
    public static final String PROP_RESOURCE_NAME = "resource.name";
    public static final String PROP_PLATFORM_NAME = "platform.name";
    public static final String PROP_PLATFORM_DISPLAY_NAME = "platform.display.name";
    public static final String PROP_PLATFORM_TYPE = "platform.type";
    public static final String PROP_PLATFORM_FQDN = "platform.fqdn";
    public static final String PROP_PLATFORM_IP = "platform.ip";
    public static final String PROP_PLATFORM_ID = "platform.id";
    public static final String PROP_PLATFORM_MACADDR = "platform.macaddr";
    public static final int DEPLOYMENT_ORDER_LAST = 4;
    public static final String DEFAULT_INSTALLPATH = "/usr/local/apps";
    public static final String[] TYPES = new String[]{"autoinventory", "control", "measurement", "product", "responsetime", "log_track", "livedata"};
    public static final String[] CONFIGURABLE_TYPES = new String[]{"product", "measurement", "control", "responsetime"};
    public static final int CFGTYPE_IDX_PRODUCT = 0;
    public static final int CFGTYPE_IDX_MEASUREMENT = 1;
    public static final int CFGTYPE_IDX_CONTROL = 2;
    public static final int CFGTYPE_IDX_RESPONSE_TIME = 3;
    protected ProductPluginManager manager;
    private static Map scriptLanguagePlugins = new HashMap();
    private static final Log _log = LogFactory.getLog((String)ProductPlugin.class.getName());

    public String getInstallPath() {
        String prop = this.getName() + "." + PROP_INSTALLPATH;
        return this.getManager().getProperty(prop);
    }

    protected void addScriptLanguage(ScriptLanguagePlugin plugin) {
        scriptLanguagePlugins.put("." + plugin.getExtension(), plugin);
        _log.debug((Object)(ScriptLanguagePlugin.class.getName() + " " + plugin.getExtension() + " registered"));
    }

    @Override
    public void init(PluginManager manager) throws PluginException {
        this.manager = (ProductPluginManager)manager;
        String installpath = this.getInstallPath();
        if (installpath != null) {
            this.adjustClassPath(installpath);
        }
    }

    protected ProductPluginManager getManager() {
        return this.manager;
    }

    static String[] getDataClassPath(PluginData data) {
        if (data == null) {
            return new String[0];
        }
        List cp = data.getClassPath();
        if (cp == null) {
            return new String[0];
        }
        return cp.toArray(new String[0]);
    }

    public String[] getClassPath(ProductPluginManager manager) {
        return ProductPlugin.getDataClassPath(this.data);
    }

    private static Class loadClass(ClassLoader loader, String name) throws ClassNotFoundException {
        try {
            return loader.loadClass(name);
        }
        catch (ClassNotFoundException nfe) {
            if (name.startsWith("net.hyperic")) {
                String orgName = "org" + name.substring(3);
                try {
                    return loader.loadClass(orgName);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            throw nfe;
        }
    }

    private static Class loadJavaClass(ClassLoader loader, PluginData data, String name, String pluginName) {
        try {
            return ProductPlugin.loadClass(loader, name);
        }
        catch (ClassNotFoundException e) {
            try {
                _log.debug((Object)("Trying data ClassLoader to load: " + name + " for plugin " + pluginName));
                return ProductPlugin.loadClass(data.getClassLoader(), name);
            }
            catch (ClassNotFoundException e2) {
                String msg = "Unable to load " + name + " for plugin " + pluginName;
                if (PluginData.getServiceExtension(pluginName) == null) {
                    _log.error((Object)(pluginName + " - " + msg));
                } else {
                    _log.debug((Object)(pluginName + " - " + msg + ": " + e));
                }
                return null;
            }
        }
    }

    private static Class getScriptClass(ScriptLanguagePlugin plugin, ClassLoader loader, PluginData data, String className) throws PluginException {
        Properties props = data.getProperties();
        String script = props.getProperty(className, className);
        File file = new File(script);
        if (file.exists()) {
            _log.debug((Object)(className + "->" + file));
        } else {
            String pluginName = data.getPluginName();
            String work = ProductPluginManager.getPdkWorkDir() + "/" + "scripts/" + pluginName + "/" + file.getName();
            _log.debug((Object)(className + " (" + pluginName + "-plugin.jar) -> " + work));
            file = new File(work);
            if (!file.exists()) {
                _log.error((Object)("Unable to locate: " + className));
            }
        }
        try {
            return plugin.loadClass(loader, props, file);
        }
        catch (Exception e) {
            throw new PluginException(e.toString(), e);
        }
    }

    static Class getPluginClass(ClassLoader loader, PluginData data, String name, String pluginName) {
        for (Map.Entry ent : scriptLanguagePlugins.entrySet()) {
            String ext = (String)ent.getKey();
            if (!name.endsWith(ext)) continue;
            ScriptLanguagePlugin plugin = (ScriptLanguagePlugin)ent.getValue();
            try {
                return ProductPlugin.getScriptClass(plugin, loader, data, name);
            }
            catch (PluginException e) {
                _log.error((Object)(pluginName + " - " + e.getMessage()), (Throwable)((Object)e));
                return null;
            }
        }
        return ProductPlugin.loadJavaClass(loader, data, name, pluginName);
    }

    static GenericPlugin getPlugin(GenericPlugin plugin, String name, String type, TypeInfo info) {
        String pluginName = info.getName();
        Class pluginClass = ProductPlugin.getPluginClass(plugin.getClass().getClassLoader(), plugin.data, name, pluginName);
        if (pluginClass == null) {
            return null;
        }
        try {
            return (GenericPlugin)pluginClass.newInstance();
        }
        catch (Exception e) {
            _log.error((Object)(pluginName + " - Error creating " + pluginClass.getName() + ": " + e), (Throwable)e);
            return null;
        }
    }

    public GenericPlugin getPlugin(String type, TypeInfo info) {
        if (this.data == null) {
            return null;
        }
        String name = this.data.getPlugin(type, info);
        if (name == null) {
            return null;
        }
        return ProductPlugin.getPlugin(this, name, type, info);
    }

    @Override
    public ConfigSchema getConfigSchema(TypeInfo info, ConfigResponse config) {
        ConfigSchema schema;
        if (this.data != null && (schema = this.data.getConfigSchema(info, 0)) != null) {
            return schema;
        }
        return super.getConfigSchema(info, config);
    }

    public TypeInfo[] getTypes() {
        if (this.data != null) {
            return this.data.getTypes();
        }
        return new TypeInfo[0];
    }

    protected File getWorkDir(String type) {
        String pdk = ProductPluginManager.getPdkDir();
        if (pdk == null) {
            return null;
        }
        return ClientPluginDeployer.getSubDirectory(pdk, type, this.getName());
    }

    protected int getDeploymentOrder() {
        TypeInfo[] types = this.getTypes();
        int order = 4;
        if (types == null) {
            return order;
        }
        for (TypeInfo type : types) {
            order = Math.min(order, type.getType());
        }
        return order;
    }
}

