/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import org.hyperic.util.encoding.Base64;

public class RtStat
implements Serializable {
    public static final String NULL_IP = "0.0.0.0";
    public static final String NULL_URL = "?unknown-url?";
    private String ip = null;
    private String url = null;
    private long begin = Long.MAX_VALUE;
    private long end = Long.MIN_VALUE;
    private double min = Double.NaN;
    private double max = Double.NEGATIVE_INFINITY;
    private double total = 0.0;
    private int count = 0;
    private Hashtable status = null;
    private Integer svcID;
    private int svcType = 0;

    public RtStat() {
    }

    public RtStat(Integer svcID) {
        this(svcID, 0);
    }

    public RtStat(Integer svcID, String ip) {
        this(svcID, 0, ip);
    }

    public RtStat(Integer svcID, int svcType) {
        this(svcID, svcType, null);
    }

    public RtStat(Integer svcID, int svcType, String ip) {
        this.ip = ip;
        this.svcID = svcID;
        this.svcType = svcType;
        this.status = new Hashtable();
    }

    public void recompute(String givenurl, Date date, double timetaken, Integer statcode) {
        if (this.url == null) {
            this.url = givenurl;
        }
        long finish = date.getTime() + (long)timetaken;
        long start = date.getTime();
        if (start < this.begin) {
            this.begin = start;
        }
        if (finish > this.end) {
            this.end = finish;
        }
        if (statcode.compareTo(new Integer(200)) >= 0 && statcode.compareTo(new Integer(300)) < 0) {
            ++this.count;
            this.total += timetaken;
            if ((timetaken < this.min || Double.isNaN(this.min)) && timetaken >= 0.0) {
                this.min = timetaken;
            }
            if (timetaken > this.max) {
                this.max = timetaken;
            }
        } else if (this.status.get(statcode) == null) {
            this.status.put(statcode, new Integer(1));
        } else {
            Integer number = (Integer)this.status.get(statcode);
            this.status.put(statcode, new Integer(number + 1));
        }
    }

    public void recompute(RtStat rs) {
        if (rs == null) {
            return;
        }
        if (this.svcType == 0) {
            this.svcType = rs.svcType;
        }
        if (this.url == null) {
            this.url = rs.url;
        }
        if (this.ip == null) {
            this.ip = rs.ip;
        }
        if (rs.getBegin() < this.begin) {
            this.begin = rs.begin;
        }
        if (rs.getEnd() > this.end) {
            this.end = rs.end;
        }
        if (rs.count > 0) {
            this.count += rs.count;
            if (rs.min > 0.0) {
                this.total += rs.total;
            }
            if ((rs.min < this.min || Double.isNaN(this.min)) && rs.min >= 0.0) {
                this.min = rs.min;
            }
            if (rs.max > this.max) {
                this.max = rs.max;
            }
        } else {
            Enumeration en = rs.status.keys();
            while (en.hasMoreElements()) {
                Integer stat = (Integer)en.nextElement();
                Integer number = (Integer)this.status.get(stat);
                if (number == null) {
                    number = new Integer(0);
                }
                this.status.put(stat, new Integer(number + (Integer)rs.status.get(stat)));
            }
        }
    }

    public String getIp() {
        if (this.ip == null || this.ip.length() == 0) {
            return NULL_IP;
        }
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void resetIp() {
        this.ip = null;
    }

    public String getUrl() {
        return this.url == null ? NULL_URL : this.url;
    }

    public void setUrl(String u) {
        this.url = u;
    }

    public long getBegin() {
        return this.begin;
    }

    public void setBegin(long d) {
        this.begin = d;
    }

    public long getEnd() {
        return this.end;
    }

    public void setEnd(long d) {
        this.end = d;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getTotal() {
        return this.total;
    }

    public void setTotal(double total) {
        this.total = total;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public Hashtable getStatus() {
        return this.status;
    }

    public void setStatus(Hashtable st) {
        this.status = st;
    }

    public Integer getSvcID() {
        return this.svcID;
    }

    public void setSvcID(Integer ID) {
        this.svcID = ID;
    }

    public int getSvcType() {
        return this.svcType;
    }

    public void setSvcType(int st) {
        this.svcType = st;
    }

    public double getAverage() {
        return this.count == 0 ? 0.0 : this.total / (double)this.count;
    }

    public boolean isEndUser() {
        return this.svcType == 1;
    }

    public String getIpUrlKey() {
        return this.getIp() + ":" + this.getUrl();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RtStat").append(" svcid=").append(this.svcID).append(" ip=").append(this.getIp()).append(" url=").append(this.getUrl()).append(" min=").append(this.min).append(" max=").append(this.max).append(" count=").append(this.count).append(" total=").append(this.total).append(" begin=").append(this.begin).append(" end=").append(this.end).append(" status=").append(this.status).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() throws IOException {
        ByteArrayOutputStream bOs = null;
        FilterOutputStream dOs = null;
        try {
            bOs = new ByteArrayOutputStream();
            dOs = new DataOutputStream(bOs);
            ((DataOutputStream)dOs).writeUTF(this.getIp());
            ((DataOutputStream)dOs).writeUTF(this.url);
            ((DataOutputStream)dOs).writeLong(this.begin);
            ((DataOutputStream)dOs).writeLong(this.end);
            ((DataOutputStream)dOs).writeDouble(this.min);
            ((DataOutputStream)dOs).writeDouble(this.max);
            ((DataOutputStream)dOs).writeDouble(this.total);
            ((DataOutputStream)dOs).writeInt(this.count);
            ((DataOutputStream)dOs).writeInt(this.svcType);
            ((DataOutputStream)dOs).writeInt(this.svcID);
            ((DataOutputStream)dOs).writeInt(this.status.size());
            Enumeration keys = this.status.keys();
            while (keys.hasMoreElements()) {
                Integer key = (Integer)keys.nextElement();
                int val = (Integer)this.status.get(key);
                ((DataOutputStream)dOs).writeInt(key);
                ((DataOutputStream)dOs).writeInt(val);
            }
            String string = Base64.encode((byte[])bOs.toByteArray());
            return string;
        }
        finally {
            dOs.close();
            bOs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RtStat decode(String val) throws IOException {
        ByteArrayInputStream bIs = null;
        FilterInputStream dIs = null;
        RtStat rs = new RtStat();
        try {
            int numEntries;
            bIs = new ByteArrayInputStream(Base64.decode((String)val));
            dIs = new DataInputStream(bIs);
            rs.ip = ((DataInputStream)dIs).readUTF();
            rs.url = ((DataInputStream)dIs).readUTF();
            rs.begin = ((DataInputStream)dIs).readLong();
            rs.end = ((DataInputStream)dIs).readLong();
            rs.min = ((DataInputStream)dIs).readDouble();
            rs.max = ((DataInputStream)dIs).readDouble();
            rs.total = ((DataInputStream)dIs).readDouble();
            rs.count = ((DataInputStream)dIs).readInt();
            rs.svcType = ((DataInputStream)dIs).readInt();
            rs.svcID = new Integer(((DataInputStream)dIs).readInt());
            rs.status = new Hashtable(numEntries);
            for (numEntries = ((DataInputStream)dIs).readInt(); numEntries > 0; --numEntries) {
                Integer key = new Integer(((DataInputStream)dIs).readInt());
                Integer value = new Integer(((DataInputStream)dIs).readInt());
                rs.status.put(key, value);
            }
            RtStat rtStat = rs;
            return rtStat;
        }
        finally {
            dIs.close();
            bIs.close();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RtStat)) {
            return false;
        }
        RtStat o = (RtStat)obj;
        return this.getIp().equals(o.getIp()) && this.url.equals(o.url) && this.begin == o.begin && this.end == o.end && Double.isNaN(this.min) && Double.isNaN(o.min) && this.max == o.max && this.total == o.total && this.count == o.count && this.svcType == o.svcType && this.svcID.equals(o.svcID) && this.status.equals(o.status);
    }
}

