/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.autoinventory.AICompare;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.StringUtil;

public class RuntimeResourceReport {
    private int _serverId = -1;
    private AIPlatformValue[] _aiplatforms;

    public RuntimeResourceReport() {
    }

    public RuntimeResourceReport(int serverId) {
        this._serverId = serverId;
    }

    public int getServerId() {
        return this._serverId;
    }

    public void setServerId(int serverId) {
        this._serverId = serverId;
    }

    public AIPlatformValue[] getAIPlatforms() {
        return this._aiplatforms;
    }

    public void setAIPlatforms(AIPlatformValue[] aiplatforms) {
        this._aiplatforms = aiplatforms;
    }

    public void addAIPlatform(AIPlatformValue aiplatform) {
        Object[] newArray = new AIPlatformValue[]{aiplatform};
        this._aiplatforms = (AIPlatformValue[])ArrayUtil.combine((Object[])this._aiplatforms, (Object[])newArray);
    }

    public void addAIPlatforms(AIPlatformValue[] aiplatforms) {
        this._aiplatforms = (AIPlatformValue[])ArrayUtil.combine((Object[])this._aiplatforms, (Object[])aiplatforms);
    }

    public boolean isSameReport(RuntimeResourceReport other) {
        AIPlatformValue[] p2;
        if (this.getServerId() != other.getServerId()) {
            return false;
        }
        AIPlatformValue[] p1 = this.getAIPlatforms();
        if (p1.length != (p2 = other.getAIPlatforms()).length) {
            return false;
        }
        for (int i = 0; i < p1.length; ++i) {
            boolean foundPlatform = false;
            for (int j = 0; j < p2.length; ++j) {
                if (!AICompare.compareAIPlatforms(p1[i], p2[j])) continue;
                foundPlatform = true;
                break;
            }
            if (foundPlatform) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[RuntimeResourceReport serverId=").append(this._serverId);
        if (this._aiplatforms != null) {
            sb.append(" platforms={");
            for (int i = 0; i < this._aiplatforms.length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                if (this._aiplatforms[i] == null) {
                    sb.append("NULL-PLATFORM");
                    continue;
                }
                sb.append(this._aiplatforms[i]);
                Object[] servers = this._aiplatforms[i].getAIServerValues();
                if (servers != null) {
                    sb.append(" platform-servers=").append(StringUtil.arrayToString((Object[])servers));
                    continue;
                }
                sb.append(" platform-servers=NONE");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

