/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hyperic.sigar.OperatingSystem;

public class SupportedOperatingSystem {
    private static final Set<String> supportedUnixPlatforms = new HashSet<String>();
    private static final Set<String> supportedWindowsPlatforms = new HashSet<String>();
    private static final Set<String> supportedPlatforms = new HashSet<String>();

    public static boolean isSupported(String name) {
        return supportedPlatforms.contains(name);
    }

    public static Set<String> getSupportedPlatforms() {
        return supportedPlatforms;
    }

    public static Set<String> getSupportedUnixPlatforms() {
        return supportedUnixPlatforms;
    }

    public static Set<String> getSupportedWindowsPlatforms() {
        return supportedWindowsPlatforms;
    }

    static {
        Collections.addAll(supportedUnixPlatforms, OperatingSystem.UNIX_NAMES);
        supportedUnixPlatforms.remove("MacOSX");
        supportedUnixPlatforms.remove("FreeBSD");
        supportedUnixPlatforms.remove("NetBSD");
        supportedUnixPlatforms.remove("OpenBSD");
        Collections.addAll(supportedWindowsPlatforms, OperatingSystem.WIN32_NAMES);
        supportedPlatforms.addAll(supportedUnixPlatforms);
        supportedPlatforms.addAll(supportedWindowsPlatforms);
    }
}

