/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hyperic.hq.product.pluginxml.ConfigTag;
import org.hyperic.hq.product.pluginxml.PluginData;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigSchema;

class LateBindingConfigSchema
extends ConfigSchema {
    private List includes;
    private Properties props;

    LateBindingConfigSchema(List includes, Properties props) {
        this.includes = includes;
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)props);
    }

    public List getOptions() {
        int size = this.includes.size();
        if (size != 0) {
            for (int i = 0; i < size; ++i) {
                String name = (String)this.includes.get(i);
                ConfigSchema schema = PluginData.getSharedConfigSchema(name);
                if (schema == null) {
                    String msg = "Unable to resolve config include=" + name;
                    throw new IllegalArgumentException(msg);
                }
                List options = schema.getOptions();
                for (int j = 0; j < options.size(); ++j) {
                    ConfigOption option = (ConfigOption)options.get(j);
                    if (this.getOption(option.getName()) != null) continue;
                    String defVal = this.props.getProperty(option.getName());
                    option = ConfigTag.includeConfigOption(option, defVal);
                    this.addOption(option);
                }
            }
            this.includes.clear();
            this.props.clear();
            this.props = null;
        }
        return super.getOptions();
    }
}

