/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.panel;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.panel.IProperty;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.util.EventListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

class AdvancedProperties {
    private static EventListenerList newPluginEnabledListeners = new EventListenerList();

    AdvancedProperties() {
    }

    static void addStatusChangedListener(NewPluginEnableListener newPluginEnableListener) {
        newPluginEnabledListeners.add(NewPluginEnableListener.class, newPluginEnableListener);
    }

    static void removeStatusChangedListener(NewPluginEnableListener newPluginEnableListener) {
        newPluginEnabledListeners.remove(NewPluginEnableListener.class, newPluginEnableListener);
    }

    private static void fireEvent(NewPluginEnableEvent newPluginEnableEvent) {
        Object[] objectArray = newPluginEnabledListeners.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != NewPluginEnableListener.class) continue;
            ((NewPluginEnableListener)objectArray[i + 1]).newPluginEnableChanged(newPluginEnableEvent);
        }
    }

    static String getOldPluginSliderDescription() {
        return ResourceManager.getString("deployment.security.slider.oldplugin");
    }

    static NewPluginEnableManager prepareToSaveNewPluginEnabled() {
        boolean bl = Platform.get().getJavaPluginSettings();
        Config.get().storeIfNeeded();
        boolean bl2 = Config.getBooleanProperty("deployment.jpi.mode.new");
        NewPluginEnableManager newPluginEnableManager = new NewPluginEnableManager(bl, bl2);
        return newPluginEnableManager;
    }

    static boolean saveRoamingProfileSettings() {
        boolean bl;
        boolean bl2 = false;
        boolean bl3 = Config.getBooleanProperty("deployment.roaming.profile");
        if (bl3 != (bl = Config.get().useRoamingProfile())) {
            Platform.get().enableRoamingProfile(bl3);
            bl2 = bl3 == Config.get().useRoamingProfile();
        }
        return bl2;
    }

    static class NewPluginOptionListener
    implements TreeModelListener {
        NewPluginOptionListener() {
        }

        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            IProperty iProperty;
            TreePath treePath = treeModelEvent.getTreePath();
            Object object = treePath.getLastPathComponent();
            if (object instanceof IProperty && (iProperty = (IProperty)object).getPropertyName().equals("deployment.jpi.mode.new") && iProperty.getValue().equals("false") && NewPluginOptionListener.showNewPluginDisabledWarning() != 0) {
                iProperty.setValue("true");
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        }

        private static int showNewPluginDisabledWarning() {
            return ToolkitStore.getUI().showMessageDialog(null, null, 2, ResourceManager.getString("security.dialog.caption"), ResourceManager.getString("deployment.securiry.oldplugin.warning.masthead"), ResourceManager.getString("deployment.securiry.oldplugin.warning.message"), null, ResourceManager.getString("deployment.securiry.oldplugin.warning.button.disable"), ResourceManager.getString("deployment.securiry.oldplugin.warning.button.cancel"), null, null, null, 1);
        }
    }

    static class NewPluginEnableManager {
        private final boolean previousState;
        private final boolean desiredState;
        private boolean isDialogShown;

        public NewPluginEnableManager(boolean bl, boolean bl2) {
            this.previousState = bl;
            this.desiredState = bl2;
            this.isDialogShown = false;
        }

        public boolean isDialogShown() {
            return this.isDialogShown;
        }

        public void saveIfChanging(boolean bl) {
            if (this.desiredState != this.previousState) {
                int n = Platform.get().setJavaPluginSettings(this.desiredState);
                if (!bl) {
                    if (n == 1) {
                        this.showPluginSwitchFailDialog();
                    } else if (n != 2) {
                        this.showPluginSwitchSuccessDialog();
                    }
                    this.isDialogShown = true;
                }
                AdvancedProperties.fireEvent(new NewPluginEnableEvent(this.desiredState));
            }
        }

        private void showPluginSwitchFailDialog() {
            String string = ResourceManager.getString("common.ok_btn");
            String string2 = ResourceManager.getString("common.detail.button");
            ToolkitStore.getUI().showMessageDialog(null, null, 0, ResourceManager.getMessage("jpi.settings.fail.caption"), ResourceManager.getMessage("jpi.settings.fail.masthead"), ResourceManager.getMessage("jpi.settings.fail.text"), null, string, string2, null);
        }

        private void showPluginSwitchSuccessDialog() {
            ToolkitStore.getUI().showMessageDialog(null, null, 1, ResourceManager.getMessage("jpi.settings.success.caption"), ResourceManager.getMessage("jpi.settings.success.masthead"), ResourceManager.getMessage("jpi.settings.success.text"), null, null, null, null);
        }
    }

    static interface NewPluginEnableListener
    extends EventListener {
        public void newPluginEnableChanged(NewPluginEnableEvent var1);
    }

    static class NewPluginEnableEvent {
        boolean enabled;

        public NewPluginEnableEvent(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }
}

