/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.io.IOException;
import java.io.InputStream;

public class RandomByteInputStream
extends InputStream {
    protected int pos = 0;
    protected int count;
    protected char random;

    public RandomByteInputStream(int length) {
        this.count = length;
        this.random = (char)(Math.random() * 57.0 + 65.0);
    }

    private void getRandomBytes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)this.random;
        }
    }

    @Override
    public synchronized int read() {
        if (this.pos < this.count) {
            byte[] b = new byte[1];
            this.getRandomBytes(b);
            return b[0] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        byte[] buf = new byte[len];
        this.getRandomBytes(buf);
        System.arraycopy(buf, 0, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public synchronized long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) {
        throw new UnsupportedOperationException("Operation not supported!");
    }

    @Override
    public synchronized void reset() {
        throw new UnsupportedOperationException("Operation not supported!");
    }

    @Override
    public void close() throws IOException {
    }
}

