/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hyperic.util.config.ConfigOption;
import org.hyperic.util.config.ConfigOptionDisplay;
import org.hyperic.util.config.InvalidOptionValueException;

public class InstallConfigOption
extends ConfigOption
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List _values = new ArrayList();

    public InstallConfigOption(String optName, String optDesc, ConfigOptionDisplay defValue, ConfigOptionDisplay[] installOptionValues) {
        this(optName, optDesc, defValue, installOptionValues, null);
    }

    public InstallConfigOption(String optName, String optDesc, ConfigOptionDisplay defValue, ConfigOptionDisplay[] installOptionValues, String confirm) {
        super(optName, optDesc, defValue.getName());
        for (int i = 0; i < installOptionValues.length; ++i) {
            if (installOptionValues[i] == null || installOptionValues[i].getName().length() <= 0) continue;
            this._values.add(installOptionValues[i]);
        }
        if (confirm != null) {
            this.setConfirm(confirm);
        }
    }

    public void addValue(ConfigOptionDisplay option) {
        this._values.add(option);
    }

    public List getValues() {
        return this._values;
    }

    @Override
    public void checkOptionIsValid(String value) throws InvalidOptionValueException {
        boolean valid = false;
        for (int x = 0; x < this._values.size(); ++x) {
            if (!((ConfigOptionDisplay)this._values.get(x)).getName().equals(value)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            throw this.invalidOption("must be one of options presented below. value: " + value);
        }
    }

    @Override
    public String getDefault() {
        String defVal = super.getDefault();
        if (defVal == null && this._values.size() > 0) {
            defVal = ((ConfigOptionDisplay)this._values.get(0)).getName();
        }
        return defVal;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

