/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.file.CreateOrOverwriteWriter;
import org.hyperic.util.file.WriterHandler;
import org.hyperic.util.security.MD5;

public class FileWriter
extends WriterHandler {
    private final Log log = LogFactory.getLog(FileWriter.class);
    private File destFile;
    private InputStream inStream;
    private WriterHandler writer;
    private String expectedMD5Sum;

    public FileWriter(File destFile, InputStream inStream, String expectedMD5Sum) {
        this.destFile = destFile;
        this.inStream = inStream;
        this.writer = new CreateOrOverwriteWriter(this.destFile, this.inStream);
        this.expectedMD5Sum = expectedMD5Sum;
    }

    public File getDestFile() {
        return this.destFile;
    }

    @Override
    public void rollback() throws IOException {
        super.rollback();
        this.writer.rollback();
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.writer.cleanup();
    }

    @Override
    public void write() throws IOException {
        super.write();
        this.writer.write();
    }

    public void verifyMD5CheckSum() throws IOException {
        if (this.writer == null || !this.writer.hasWritten()) {
            throw new IllegalStateException("the file must be written before verifying the MD5 check sum");
        }
        if (this.expectedMD5Sum != null) {
            String actualMD5Sum = MD5.getMD5Checksum(this.getDestFile());
            this.log.debug((Object)("Verifying MD5 check sum for file " + this.getDestFile() + "; expected=" + this.expectedMD5Sum + ", actual=" + actualMD5Sum));
            if (!this.expectedMD5Sum.equals(actualMD5Sum)) {
                throw new IOException("MD5 check sum failed for file " + this.getDestFile() + "; expected=" + this.expectedMD5Sum + ", actual=" + actualMD5Sum);
            }
        }
    }
}

