/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file.match;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.selectors.FileSelector;
import org.apache.tools.ant.util.FileUtils;
import org.hyperic.util.file.match.MasterMatchSelector;
import org.hyperic.util.file.match.MatchSelector;
import org.hyperic.util.file.match.MatcherException;
import org.hyperic.util.file.match.MatcherInterruptCallback;
import org.hyperic.util.file.match.MatcherInterruptedException;
import org.hyperic.util.file.match.MatcherProgressCallback;

class MatcherScanner
extends DirectoryScanner {
    private int maxDepth;
    private Log log;
    private MatcherInterruptCallback interruptCB = null;
    private MatcherProgressCallback progressCB = null;
    private Map matches;
    private List errors = new ArrayList();
    private boolean myFollowSymlinks = false;
    private static final FileUtils myFileUtils = FileUtils.newFileUtils();
    private int pauseCounter = 0;

    public void initMatches(Map matches) {
        this.matches = matches;
    }

    public List getErrors() {
        return this.errors;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public void setMaxDepth(int max) {
        this.maxDepth = max;
    }

    public Log getLog() {
        return this.log;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setMatcherInterruptCB(MatcherInterruptCallback icb) {
        this.interruptCB = icb;
    }

    public void setMatcherProgressCB(MatcherProgressCallback pcb) {
        this.progressCB = pcb;
    }

    protected void addMatch(Object key, String fullpath) {
        ArrayList<String> existingList = (ArrayList<String>)this.matches.get(key);
        if (existingList == null) {
            existingList = new ArrayList<String>();
            this.matches.put(key, existingList);
        }
        existingList.add(fullpath);
    }

    public Map getMatches() {
        return this.matches;
    }

    public void setSelectors(FileSelector[] selectors) {
        super.setSelectors(selectors);
        for (int i = 0; i < selectors.length; ++i) {
            if (!(selectors[i] instanceof MatchSelector)) continue;
            ((MatchSelector)selectors[i]).setMatcherScanner(this);
        }
    }

    public void setFollowSymlinks(boolean followSymlinks) {
        this.myFollowSymlinks = followSymlinks;
        super.setFollowSymlinks(followSymlinks);
    }

    public void doScan() throws MatcherInterruptedException {
        this.checkInterrupted();
        for (int i = 0; i < this.selectors.length; ++i) {
            if (!(this.selectors[i] instanceof MasterMatchSelector)) continue;
            ((MasterMatchSelector)this.selectors[i]).setScanner(this);
        }
        super.scan();
    }

    private void checkInterrupted() throws MatcherInterruptedException {
        if (this.interruptCB != null ? this.interruptCB.getIsInterrupted() : Thread.currentThread().isInterrupted()) {
            throw new MatcherInterruptedException();
        }
    }

    protected void scandir(File dir, String vpath, boolean fast) {
        this.pauseCounter = 0;
        this.scandir(dir, vpath, 0);
    }

    private void pause() {
        if (++this.pauseCounter % 25 == 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                throw new MatcherInterruptedException();
            }
        }
    }

    protected void scandir(File dir, String vpath, int depth) {
        this.pause();
        if (depth > this.maxDepth && this.maxDepth != -1) {
            if (this.log != null) {
                // empty if block
            }
            return;
        }
        this.checkInterrupted();
        if (this.isExcluded(dir.getAbsolutePath())) {
            return;
        }
        if (!dir.canRead()) {
            this.errors.add(new MatcherException("Don't have permissions to read directory: " + dir.getAbsolutePath()));
            return;
        }
        Object[] newfiles = dir.list();
        if (newfiles == null) {
            this.errors.add(new MatcherException("IO error scanning directory " + dir.getAbsolutePath()));
            return;
        }
        if (this.progressCB != null) {
            this.progressCB.notifyScanDir(dir);
        }
        if (!this.myFollowSymlinks) {
            Vector<Object> noLinks = new Vector<Object>();
            for (int i = 0; i < newfiles.length; ++i) {
                this.checkInterrupted();
                try {
                    if (myFileUtils.isSymbolicLink(dir, (String)newfiles[i])) {
                        String name = vpath + (String)newfiles[i];
                        File file = new File(dir, (String)newfiles[i]);
                        if (file.isDirectory()) {
                            this.dirsExcluded.addElement(name);
                            continue;
                        }
                        this.filesExcluded.addElement(name);
                        continue;
                    }
                    noLinks.addElement(newfiles[i]);
                    continue;
                }
                catch (IOException ioe) {
                    String msg = "IOException caught while checking for links, couldn't get canonical path!";
                    this.errors.add(new MatcherException(msg, ioe));
                }
            }
            newfiles = new String[noLinks.size()];
            noLinks.copyInto(newfiles);
        }
        for (int i = 0; i < newfiles.length; ++i) {
            this.checkInterrupted();
            this.pause();
            String name = vpath + (String)newfiles[i];
            File file = new File(dir, (String)newfiles[i]);
            if (file.isDirectory()) {
                if (this.isIncluded(name)) {
                    if (!this.isExcluded(name)) {
                        if (this.isSelected(name, file) || !this.couldHoldIncluded(name)) continue;
                        this.scandir(file, name + File.separator, depth + 1);
                        continue;
                    }
                    if (!this.couldHoldIncluded(name)) continue;
                    this.scandir(file, name + File.separator, depth + 1);
                    continue;
                }
                if (!this.couldHoldIncluded(name)) continue;
                this.scandir(file, name + File.separator, depth + 1);
                continue;
            }
            if (file.isFile() && this.isIncluded(name) && !this.isExcluded(name) && !this.isSelected(name, file)) continue;
        }
    }
}

