/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.http;

import java.io.IOException;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.hyperic.util.http.AgentRequest;
import org.hyperic.util.http.CommunicationConfiguration;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.http.HttpConfig;
import org.hyperic.util.http.ServersManager;
import org.hyperic.util.security.CertificateService;
import org.hyperic.util.security.KeystoreConfig;

public class ServerHttpClient
extends HQHttpClient {
    private final X500Principal userToken;
    protected final int maxRequestsPerConnection;
    protected volatile int connectionCounter;
    protected ServersManager serversManager;

    public ServerHttpClient(KeystoreConfig keyConfig, HttpConfig config, boolean acceptUnverifiedCertificates, ClientConnectionManager conman, int maxRequestsPerConnection, boolean isSupportRRDNS, int failPeriodInMin, int downPeriodInMin) {
        super(keyConfig, config, acceptUnverifiedCertificates, conman);
        this.maxRequestsPerConnection = maxRequestsPerConnection;
        this.userToken = CertificateService.getClientCertificateSubjectPrincipal(keyConfig);
        this.connectionCounter = 0;
        CommunicationConfiguration communicationConfiguration = new CommunicationConfiguration(isSupportRRDNS, failPeriodInMin, downPeriodInMin);
        this.serversManager = new ServersManager(this, communicationConfiguration);
    }

    public ServerHttpClient(KeystoreConfig keyConfig, HttpConfig config, boolean acceptUnverifiedCertificates, int maxRequestsPerConnection, boolean isSupportRRDNS, int failPeriodInMin, int downPeriodInMin) {
        this(keyConfig, config, acceptUnverifiedCertificates, null, maxRequestsPerConnection, isSupportRRDNS, failPeriodInMin, downPeriodInMin);
    }

    protected HttpContext createHttpContext() {
        HttpContext httpContext = super.createHttpContext();
        if (this.userToken != null) {
            httpContext.setAttribute("http.user-token", (Object)this.userToken);
        }
        return httpContext;
    }

    public HttpResponse post(String url, Map<String, String> params, boolean closeConn) throws ClientProtocolException, IOException {
        AgentRequest request = new AgentRequest(url, AgentRequest.AgentHttpMethod.POST);
        request.setParams(params);
        return this.send(request, closeConn);
    }

    public HttpResponse get(String url, boolean closeConn) throws ClientProtocolException, IOException {
        AgentRequest request = new AgentRequest(url, AgentRequest.AgentHttpMethod.GET);
        return this.send(request, closeConn);
    }

    private HttpResponse send(AgentRequest request, boolean closeConn) throws ClientProtocolException, IOException {
        if (closeConn || this.connectionCounter >= this.maxRequestsPerConnection) {
            this.connectionCounter = 0;
            request.getHeaders().put("Connection", "close");
        } else {
            ++this.connectionCounter;
        }
        return this.serversManager.send(request);
    }
}

