/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.ntp;

import org.hyperic.util.ntp.NtpClient;

public class NtpResponse {
    protected byte leapIndicator;
    protected byte version;
    protected byte mode;
    protected short stratum;
    protected byte interval;
    protected byte precision;
    protected double rootDelay;
    protected double rootDispersion;
    protected byte[] referenceIdentifier = new byte[4];
    protected double referenceTimestamp;
    protected double originateTimestamp;
    protected double receiveTimestamp;
    protected double transmitTimestamp;
    protected double roundTripDelay;
    protected double localClockOffset;

    private NtpResponse() {
    }

    public static byte[] getRequestBytes() {
        byte[] packet = new byte[48];
        packet[0] = 27;
        NtpResponse.encode(packet, 40, NtpClient.now());
        return packet;
    }

    public static NtpResponse decodeResponse(double ts, byte[] data) {
        NtpResponse response = new NtpResponse();
        response.leapIndicator = (byte)(data[0] >> 6 & 3);
        response.version = (byte)(data[0] >> 3 & 7);
        response.mode = (byte)(data[0] & 7);
        response.stratum = NtpResponse.unsignedByteToShort(data[1]);
        response.interval = data[2];
        response.precision = data[3];
        response.rootDelay = (double)data[4] * 256.0 + (double)NtpResponse.unsignedByteToShort(data[5]) + (double)NtpResponse.unsignedByteToShort(data[6]) / 256.0 + (double)NtpResponse.unsignedByteToShort(data[7]) / 65536.0;
        response.rootDispersion = (double)NtpResponse.unsignedByteToShort(data[8]) * 256.0 + (double)NtpResponse.unsignedByteToShort(data[9]) + (double)NtpResponse.unsignedByteToShort(data[10]) / 256.0 + (double)NtpResponse.unsignedByteToShort(data[11]) / 65536.0;
        response.referenceIdentifier[0] = data[12];
        response.referenceIdentifier[1] = data[13];
        response.referenceIdentifier[2] = data[14];
        response.referenceIdentifier[3] = data[15];
        response.referenceTimestamp = NtpResponse.decode(data, 16);
        response.originateTimestamp = NtpResponse.decode(data, 24);
        response.receiveTimestamp = NtpResponse.decode(data, 32);
        response.transmitTimestamp = NtpResponse.decode(data, 40);
        response.roundTripDelay = ts - response.originateTimestamp - (response.transmitTimestamp - response.receiveTimestamp);
        response.localClockOffset = (response.receiveTimestamp - response.originateTimestamp + (response.transmitTimestamp - ts)) / 2.0;
        return response;
    }

    private static short unsignedByteToShort(byte b) {
        if ((b & 0x80) == 128) {
            return (short)(128 + (b & 0x7F));
        }
        return b;
    }

    private static double decode(byte[] array, int start) {
        double ts = 0.0;
        for (int i = 0; i < 8; ++i) {
            ts += (double)NtpResponse.unsignedByteToShort(array[start + i]) * Math.pow(2.0, (3 - i) * 8);
        }
        return ts;
    }

    private static void encode(byte[] array, int start, double timestamp) {
        for (int i = 0; i < 8; ++i) {
            double base = Math.pow(2.0, (3 - i) * 8);
            array[start + i] = (byte)(timestamp / base);
            timestamp -= (double)NtpResponse.unsignedByteToShort(array[start + i]) * base;
        }
    }

    public double getLocalClockOffset() {
        return Math.abs(this.localClockOffset);
    }

    public double getRoundTripDelay() {
        return this.roundTripDelay;
    }

    public double getRootDelay() {
        return this.rootDelay;
    }

    public double getRootDispersion() {
        return this.rootDispersion;
    }
}

