/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.pager;

import java.io.Serializable;

public class PageControl
implements Serializable,
Cloneable {
    public static final int SIZE_UNLIMITED = -1;
    public static final int SORT_UNSORTED = 0;
    public static final int SORT_ASC = 1;
    public static final int SORT_DESC = 2;
    public static final String[] SQL_SORTS = new String[]{"", "ASC", "DESC"};
    public static final PageControl PAGE_ALL = new PageControl(0, -1, true);
    public static final PageControl PAGE_NONE = new PageControl(0, 0, true);
    public static final PageControl PAGE_MIN = new PageControl(0, 1, true);
    private int _pagenum = 0;
    private int _pagesize = -1;
    private int _sortorder = 0;
    private int _sortattribute = 0;
    private boolean _immutable = false;
    private Serializable metaData;

    private PageControl(int pagenum, int pagesize, boolean immutable) {
        this(pagenum, pagesize);
        this._immutable = immutable;
    }

    public PageControl() {
    }

    public PageControl(int pagenum, int pagesize) {
        this._pagenum = pagenum;
        this._pagesize = pagesize;
    }

    public PageControl(int pagenum, int pagesize, int sortorder, int sortattribute) {
        this._pagenum = pagenum;
        this._pagesize = pagesize;
        this._sortorder = sortorder;
        this._sortattribute = sortattribute;
    }

    public PageControl(PageControl pc) {
        this._pagenum = pc.getPagenum();
        this._pagesize = pc.getPagesize();
        this._sortorder = pc.getSortorder();
        this._sortattribute = pc.getSortattribute();
        this.metaData = pc.getMetaData();
    }

    public boolean isAscending() {
        return this._sortorder == 1;
    }

    public boolean isDescending() {
        return this._sortorder == 2;
    }

    public static PageControl initDefaults(PageControl pc, int defaultSortAttr) {
        if ((pc = pc == null ? new PageControl() : (PageControl)pc.clone()).getSortattribute() == 0) {
            pc.setSortattribute(defaultSortAttr);
        }
        if (pc.getSortorder() == 0) {
            pc.setSortorder(1);
        }
        return pc;
    }

    public int getPagenum() {
        return this._pagenum;
    }

    public void setPagenum(int pagenum) {
        if (this._immutable) {
            throw new IllegalStateException("immutable object");
        }
        this._pagenum = pagenum;
    }

    public int getPagesize() {
        return this._pagesize;
    }

    public void setPagesize(int pagesize) {
        if (this._immutable) {
            throw new IllegalStateException("immutable object");
        }
        this._pagesize = pagesize;
    }

    public int getSortorder() {
        return this._sortorder;
    }

    public void setSortorder(int sortorder) {
        if (this._immutable) {
            throw new IllegalStateException("immutable object");
        }
        this._sortorder = sortorder;
    }

    public int getSortattribute() {
        return this._sortattribute;
    }

    public void setSortattribute(int attr) {
        if (this._immutable) {
            throw new IllegalStateException("immutable object");
        }
        this._sortattribute = attr;
    }

    public Serializable getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Serializable metaData) {
        if (this._immutable) {
            throw new IllegalStateException("immutable object");
        }
        this.metaData = metaData;
    }

    public int getPageEntityIndex() {
        return this._pagenum * this._pagesize;
    }

    public String toString() {
        if (this == PAGE_ALL) {
            return "{ALL}";
        }
        if (this == PAGE_NONE) {
            return "{NONE}";
        }
        if (this.equals(PAGE_ALL)) {
            return "{ALL}";
        }
        if (this.equals(PAGE_NONE)) {
            return "{NONE}";
        }
        StringBuffer s = new StringBuffer("{");
        s.append("pn=" + this._pagenum + " ");
        s.append("ps=" + this._pagesize + " ");
        s.append("so=");
        switch (this._sortorder) {
            case 1: {
                s.append("asc ");
                break;
            }
            case 2: {
                s.append("desc");
                break;
            }
            case 0: {
                s.append("unsorted ");
                break;
            }
            default: {
                s.append(' ');
            }
        }
        s.append("sa=" + this._sortattribute + " ");
        s.append("}");
        return s.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof PageControl) {
            PageControl pc = (PageControl)o;
            return this._pagenum == pc.getPagenum() && this._pagesize == pc.getPagesize() && this._sortorder == pc.getSortorder() && this._sortattribute == pc.getSortattribute();
        }
        return false;
    }

    public int hashCode() {
        return 37 * this._pagenum + 37 * this._pagesize + 37 * this._sortorder + 37 * this._sortattribute;
    }

    public Object clone() {
        PageControl res = new PageControl(this._pagenum, this._pagesize, this._sortorder, this._sortattribute);
        res.metaData = this.metaData;
        return res;
    }
}

