/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.hyperic.util.ssh.SSHBase;
import org.hyperic.util.ssh.SSHExecException;
import org.hyperic.util.ssh.SSHRemoteException;

public class SSHRemoteExec
extends SSHBase {
    int BUFFER_SIZE = 1024;
    protected String command;

    public SSHRemoteExec(String user, String password, String host) {
        super(user, password, host);
    }

    public void execute(String command) throws SSHRemoteException, SSHExecException {
        this.execute(command, System.out, System.err);
    }

    public void execute(String command, PrintStream os, PrintStream err) throws SSHRemoteException, SSHExecException {
        Session session = null;
        ChannelExec channel = null;
        try {
            session = this.openSession();
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            channel.setOutputStream((OutputStream)os);
            channel.setErrStream((OutputStream)err);
            InputStream in = channel.getInputStream();
            channel.connect();
            byte[] buf = new byte[this.BUFFER_SIZE];
            while (true) {
                int i;
                if (in.available() > 0 && (i = in.read(buf, 0, this.BUFFER_SIZE)) >= 0) {
                    os.print(new String(buf, 0, i));
                    continue;
                }
                if (channel.isClosed()) {
                    if (channel.getExitStatus() != 0) {
                        throw new SSHExecException("Error running command:  Exit code: " + channel.getExitStatus(), channel.getExitStatus());
                    }
                    break;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {}
            }
        }
        catch (JSchException e) {
            throw new SSHRemoteException("Error connecting to host: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new SSHRemoteException("I/O error: " + e, e);
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
            if (session != null) {
                session.disconnect();
            }
        }
    }

    protected void sendAck(OutputStream out) throws IOException {
        byte[] buf = new byte[]{0};
        out.write(buf);
        out.flush();
    }

    protected void waitForAck(InputStream in) throws SSHRemoteException, IOException {
        int b = in.read();
        if (b == -1) {
            throw new SSHRemoteException("No response from server");
        }
        if (b != 0) {
            StringBuffer sb = new StringBuffer();
            int c = in.read();
            while (c > 0 && c != 10) {
                sb.append((char)c);
                c = in.read();
            }
            if (b == 1) {
                throw new SSHRemoteException("Server indicated an error: " + sb.toString());
            }
            if (b == 2) {
                throw new SSHRemoteException("Server indicated a fatal error: " + sb.toString());
            }
            throw new SSHRemoteException("Unknown response, code " + b + " message: " + sb.toString());
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 4) {
            System.err.println("Usage: ip user password cmd");
            return;
        }
        SSHRemoteExec exec = new SSHRemoteExec(args[1], args[2], args[0]);
        exec.execute(args[3], System.out, System.err);
    }
}

