/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import org.hyperic.util.units.UnitsFormat;
import org.hyperic.util.units.UnitsUtil;

public class UnitNumber {
    private double value;
    private int units;
    private int scale;

    public UnitNumber(double value, int units) {
        this(value, units, 0);
    }

    public UnitNumber(double value, int units, int scale) {
        this.value = value;
        this.units = units;
        this.scale = scale;
        UnitsUtil.checkValidUnits(units);
        UnitsUtil.checkValidScale(scale);
        UnitsUtil.checkValidScaleForUnits(units, scale);
    }

    public double getValue() {
        return this.value;
    }

    public int getUnits() {
        return this.units;
    }

    public int getScale() {
        return this.scale;
    }

    public BigDecimal getBaseValue() {
        return UnitsFormat.getBaseValue(this.value, this.units, this.scale);
    }

    public BigDecimal getScaledValue(int targScale) {
        return UnitsFormat.getScaledValue(this.getBaseValue(), this.units, targScale);
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

