/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.configuration.agent.repository.model;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hyperic.hq.configuration.agent.repository.model.ResourceKey;
import org.hyperic.hq.configuration.agent.repository.model.SchedulingInfo;
import org.hyperic.hq.product.TypeInfo;

public class ConfigurationInfo {
    private ResourceKey resourceKey;
    private String resourceKind;
    private int resourceInternalId;
    private Map<String, String> properties;
    private Map<String, String> configuration;
    private Map<String, String> securedConfiguration;
    private Map<String, Map<String, String>> lwoConfiguration;
    private Map<String, Map<String, String>> virtualServerConfiguration;
    private List<SchedulingInfo> scheduling;
    private Map<String, List<SchedulingInfo>> lwoScheduling;
    private TypeInfo typeInfo;

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(ResourceKey resourceKey) {
        this.resourceKey = resourceKey;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Map<String, String> configuration) {
        this.configuration = configuration;
    }

    public Map<String, String> getSecuredConfiguration() {
        return this.securedConfiguration;
    }

    public void setSecuredConfiguration(Map<String, String> securedconfiguration) {
        this.securedConfiguration = securedconfiguration;
    }

    public Map<String, Map<String, String>> getLwoConfiguration() {
        return this.lwoConfiguration;
    }

    public void setLwoConfiguration(Map<String, Map<String, String>> lwoConfiguration) {
        this.lwoConfiguration = lwoConfiguration;
    }

    public Map<String, Map<String, String>> getVirtualServerConfiguration() {
        return this.virtualServerConfiguration;
    }

    public void setVirtualServerConfiguration(Map<String, Map<String, String>> virtualServerConfiguration) {
        this.virtualServerConfiguration = virtualServerConfiguration;
    }

    public List<SchedulingInfo> getScheduling() {
        return this.scheduling;
    }

    public void setScheduling(List<SchedulingInfo> scheduling) {
        this.scheduling = scheduling;
    }

    public Map<String, List<SchedulingInfo>> getLwoScheduling() {
        return this.lwoScheduling;
    }

    public void setLwoScheduling(Map<String, List<SchedulingInfo>> lwoScheduling) {
        this.lwoScheduling = lwoScheduling;
    }

    public String getResourceKind() {
        return this.resourceKind;
    }

    public void setResourceKind(String resourceKind) {
        this.resourceKind = resourceKind;
    }

    public int getResourceInternalId() {
        return this.resourceInternalId;
    }

    public void setResourceInternalId(int resourceInternalId) {
        this.resourceInternalId = resourceInternalId;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(TypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    private boolean isConfigurationEquals(ConfigurationInfo other) {
        return !this.configuration.equals(other.configuration) && !this.securedConfiguration.equals(other.securedConfiguration) && !this.lwoConfiguration.equals(other.lwoConfiguration);
    }

    private boolean isSchedulingEquals(ConfigurationInfo other) {
        return this.scheduling.equals(other.scheduling);
    }

    public ChangeType compare(ConfigurationInfo other) {
        if (other == null) {
            return ChangeType.BOTH;
        }
        if (!this.resourceKey.equals(other.resourceKey) || !this.resourceKind.equals(other.resourceKind)) {
            return null;
        }
        if (this.isConfigurationEquals(other)) {
            if (this.isSchedulingEquals(other)) {
                return ChangeType.EQUAL;
            }
            return ChangeType.SCHEDULING;
        }
        if (this.isSchedulingEquals(other)) {
            return ChangeType.CONFIGURATION;
        }
        return ChangeType.BOTH;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("resourceInternalId", this.resourceInternalId).append("resourceKind", (Object)this.resourceKind).append("resourceKey", (Object)this.resourceKey).append("properties", this.properties).append("configuration", this.configuration).append("lwoConfiguration", this.lwoConfiguration).append("virtualServerConfiguration", this.virtualServerConfiguration).append("scheduling", this.scheduling).append("lwoScheduling", this.lwoScheduling).append("typeInfo", (Object)this.typeInfo).toString();
    }

    public static enum ChangeType {
        EQUAL,
        CONFIGURATION,
        SCHEDULING,
        BOTH;

    }
}

