/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.control.agent.commands;

import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.StringUtil;

public class ControlPluginCommand_args
extends AgentRemoteValue {
    private static final String PARAM_NAME = "name";
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_ID = "id";
    private static final String PARAM_COMMAND = "command";
    private static final String PARAM_ARGS = "args";

    public ControlPluginCommand_args() {
    }

    public ControlPluginCommand_args(AgentRemoteValue args) throws AgentRemoteException {
        String name = args.getValue(PARAM_NAME);
        String type = args.getValue(PARAM_TYPE);
        String id = args.getValue(PARAM_ID);
        String cmd = args.getValue(PARAM_COMMAND);
        String arguments = args.getValue(PARAM_ARGS);
        if (name == null) {
            throw new AgentRemoteException("Plugin name not given");
        }
        if (type == null) {
            throw new AgentRemoteException("Plugin type not given");
        }
        if (cmd == null) {
            throw new AgentRemoteException("Plugin command not given");
        }
        try {
            StringUtil.explodeQuoted((String)arguments);
        }
        catch (IllegalArgumentException e) {
            throw new AgentRemoteException("Invalid arguments '" + arguments + "': " + e, e);
        }
        if (id == null) {
            this.setCommand(name, type, cmd, arguments);
        } else {
            this.setCommand(name, type, new Integer(Integer.parseInt(id)), cmd, arguments);
        }
    }

    public void setCommand(String plugin, String type, String action, String args) {
        super.setValue(PARAM_NAME, plugin);
        super.setValue(PARAM_TYPE, type);
        super.setValue(PARAM_COMMAND, action);
        super.setValue(PARAM_ARGS, args);
    }

    public void setCommand(String plugin, String type, Integer id, String action, String args) {
        this.setCommand(plugin, type, action, args);
        super.setValue(PARAM_ID, id.toString());
    }

    public String getPluginName() {
        return this.getValue(PARAM_NAME);
    }

    public String getPluginType() {
        return this.getValue(PARAM_TYPE);
    }

    public String getId() {
        return this.getValue(PARAM_ID);
    }

    public String getPluginAction() {
        return this.getValue(PARAM_COMMAND);
    }

    public String[] getArgs() {
        String args = this.getValue(PARAM_ARGS);
        return StringUtil.explodeQuoted((String)args);
    }
}

