/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.livedata.agent.commands;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.EncodingException;
import org.hyperic.util.encoding.Base64;

public class LiveData_args
extends AgentRemoteValue {
    private static final String PARAM_TYPE = "type";
    private static final String PARAM_COMMAND = "command";
    private static final String PARAM_CONFIG = "config";
    private static final int MAX_VALUE_SIZE = 65500;

    public LiveData_args() {
    }

    private Map chunkConfig(String key, String value) {
        LinkedHashMap<String, String> chunkMap = new LinkedHashMap<String, String>();
        int valueLength = value.length();
        int count = 1;
        while (valueLength > 0) {
            int offset = (count - 1) * 65500;
            String newValue = valueLength > 65500 ? value.substring(offset, 65500 * count) : value.substring(offset, value.length());
            valueLength -= 65500;
            chunkMap.put(key + count, newValue);
            ++count;
        }
        return chunkMap;
    }

    public LiveData_args(AgentRemoteValue val) throws AgentRemoteException {
        ConfigResponse config;
        String type = val.getValue(PARAM_TYPE);
        String command = val.getValue(PARAM_COMMAND);
        String configStr = this.getConfigValue(val, PARAM_CONFIG);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        this.setConfig(type, command, config);
    }

    public void setConfigValue(String key, String val) {
        if (val.length() > 65500) {
            for (Map.Entry chunkEntry : this.chunkConfig(key, val).entrySet()) {
                super.setValue((String)chunkEntry.getKey(), (String)chunkEntry.getValue());
            }
        } else {
            super.setValue(key, val);
        }
    }

    public void setConfig(String type, String command, ConfigResponse config) throws AgentRemoteException {
        String configStr;
        try {
            configStr = Base64.encode((byte[])config.encode());
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to encode plugin configuration: " + e.getMessage());
        }
        super.setValue(PARAM_TYPE, type);
        super.setValue(PARAM_COMMAND, command);
        this.setConfigValue(PARAM_CONFIG, configStr);
    }

    public String getType() {
        return this.getValue(PARAM_TYPE);
    }

    public String getCommand() {
        return this.getValue(PARAM_COMMAND);
    }

    private String getConfigValue(AgentRemoteValue agentRemoteValue, String key) {
        int count = 1;
        String configValue = agentRemoteValue.getValue(key);
        if (configValue == null) {
            String chunkValue;
            configValue = "";
            while ((chunkValue = agentRemoteValue.getValue(key + count)) != null) {
                configValue = configValue + chunkValue;
                ++count;
            }
        }
        return configValue;
    }

    public ConfigResponse getConfig() throws AgentRemoteException {
        ConfigResponse config;
        String configStr = this.getConfigValue(this, PARAM_CONFIG);
        try {
            config = ConfigResponse.decode((byte[])Base64.decode((String)configStr));
        }
        catch (EncodingException e) {
            throw new AgentRemoteException("Unable to decode plugin configuration: " + e.getMessage());
        }
        return config;
    }
}

