/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.tools.db;

import java.util.List;
import org.hyperic.tools.db.Constraint;
import org.hyperic.tools.db.ConstraintImpl;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

class ConstraintImpl_FK
implements ConstraintImpl {
    private String _name = null;
    private Constraint _constraint = null;
    private int _dbtype = 0;
    private String _local = null;
    private String _references = null;
    private String _onDelete = null;

    public ConstraintImpl_FK(String name, Constraint constraint, int dbtype, Node node) throws SAXException {
        this._name = name;
        this._constraint = constraint;
        this._dbtype = dbtype;
        NamedNodeMap attrs = node.getAttributes();
        int numAttrs = attrs.getLength();
        for (int iAttr = 0; iAttr < numAttrs; ++iAttr) {
            node = attrs.item(iAttr);
            if (node.getNodeName().equalsIgnoreCase("local")) {
                this._local = node.getNodeValue();
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("references")) {
                this._references = node.getNodeValue();
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase("ondelete")) {
                this._onDelete = node.getNodeValue();
                continue;
            }
            throw new SAXException("Unrecognized attribute in ForeignKey element: " + node.getNodeName());
        }
    }

    @Override
    public void getPostCreateCommands(List postCreateCommands) {
        if (this._onDelete != null && this._dbtype == 1) {
            String table = this._constraint.getTable().getName();
            int paren1idx = this._references.indexOf("(");
            int paren2idx = this._references.lastIndexOf(")");
            String refTable = this._references.substring(0, paren1idx);
            String refColumn = this._references.substring(paren1idx + 1, paren2idx);
            postCreateCommands.add("CREATE TRIGGER " + this._name + "_t " + "BEFORE DELETE ON " + refTable + " " + "REFERENCING OLD ROW AS deleted" + refTable + " " + "FOR EACH ROW " + "DELETE FROM " + table + " " + "WHERE " + this._local + " = deleted" + refTable + "." + refColumn);
        }
    }

    @Override
    public String getCreateString() {
        if (this._name == null) {
            this._name = "";
        }
        this._onDelete = this._onDelete == null || this._dbtype == 1 ? "" : "ON DELETE " + this._onDelete.toUpperCase();
        return ", CONSTRAINT " + this._name + " FOREIGN KEY (" + this._local + ") REFERENCES " + this._references + " " + this._onDelete;
    }
}

