/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentConfig;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentNotificationHandler;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.RuntimeScanner;
import org.hyperic.hq.autoinventory.ScanConfiguration;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanListener;
import org.hyperic.hq.autoinventory.ScanManager;
import org.hyperic.hq.autoinventory.ScanState;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.autoinventory.agent.AICommandsAPI;
import org.hyperic.hq.autoinventory.agent.client.AICommandsClient;
import org.hyperic.hq.autoinventory.agent.server.AICommandsService;
import org.hyperic.hq.autoinventory.agent.server.RuntimeAutodiscoverer;
import org.hyperic.hq.bizapp.agent.CommandsAPIInfo;
import org.hyperic.hq.bizapp.client.AutoinventoryCallbackClient;
import org.hyperic.hq.bizapp.client.ProviderFetcher;
import org.hyperic.hq.bizapp.client.StorageProviderFetcher;
import org.hyperic.hq.common.SystemException;
import org.hyperic.util.AutoApproveConfig;
import org.hyperic.util.StringUtil;

public class AutoinventoryCommandsServer
implements AgentServerHandler,
AgentNotificationHandler,
ScanListener {
    public static final long AIREPORT_MAX_SLEEP_WAIT = 3600000L;
    public static final long AIREPORT_MAX_TRY_TIME = 2592000000L;
    private final AICommandsAPI _verAPI;
    private AgentDaemon _agent;
    private AgentStorageProvider _storage;
    private final Log _log;
    private RuntimeAutodiscoverer _rtAutodiscoverer;
    private AICommandsService _aiCommandsService;
    private AutoApproveConfig _autoApproveConfig;
    protected String _certDN;
    private ScanManager _scanManager;
    private volatile ScanState _lastCompletedAiScanState;
    private AutoinventoryCallbackClient _client;
    final ThreadFactory threadFactory = new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "AiReportSender");
        }
    };
    private ExecutorService aiSendReportExecutorService = Executors.newSingleThreadExecutor(this.threadFactory);
    private Future<?> aiSendReportFuture;

    public AutoinventoryCommandsServer() {
        this._verAPI = new AICommandsAPI();
        this._log = LogFactory.getLog(AutoinventoryCommandsServer.class);
    }

    public AgentAPIInfo getAPIInfo() {
        return this._verAPI;
    }

    public String[] getCommandSet() {
        return AICommandsAPI.commandSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream in, OutputStream out) throws AgentRemoteException {
        this._log.debug((Object)("AICommandsServer: asked to invoke cmd=" + cmd));
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            AgentRemoteValue agentRemoteValue = this.dispatchCommand_internal(cmd, args);
            return agentRemoteValue;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        try {
            this._agent = agent;
            this._storage = agent.getStorageProvider();
            this._client = this.setupClient(agent.getBootConfig());
            this._certDN = this._storage.getValue("agent.certDN");
        }
        catch (AgentRunningException exc) {
            throw new AgentAssertionException("Agent should be running here: " + (Object)((Object)exc), (Throwable)exc);
        }
        this._autoApproveConfig = new AutoApproveConfig(this._agent.getBootConfig().getConfDirName(), AgentConfig.getDefaultProperties().getProperty(AgentConfig.PROP_ENC_KEY_FILE[0]));
        this._rtAutodiscoverer = new RuntimeAutodiscoverer(this, this._storage, this._agent, this._client);
        this._scanManager = new ScanManager((ScanListener)this, this._log, agent.getProductPluginManager(), (RuntimeScanner)this._rtAutodiscoverer, this._autoApproveConfig, agent.getSyncModeManager());
        this._aiCommandsService = new AICommandsService(agent.getProductPluginManager(), this._rtAutodiscoverer, this._scanManager);
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e, e);
        }
        this._log.info((Object)"Registering AI Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(AICommandsClient.class, (Object)this._aiCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register AI Commands Service: " + e, e);
        }
        this._scanManager.startup();
        if (CommandsAPIInfo.getProvider((AgentStorageProvider)this._storage) == null) {
            agent.registerNotifyHandler((AgentNotificationHandler)this, CommandsAPIInfo.NOTIFY_SERVER_SET);
        } else {
            this._rtAutodiscoverer.triggerDefaultScan();
        }
        this._log.info((Object)"Autoinventory Commands Server started up");
    }

    public void handleNotification(String msgClass, String msg) {
        if (msgClass.equals(CommandsAPIInfo.NOTIFY_SERVER_SET)) {
            this._scanManager.interruptHangingScan();
            this._rtAutodiscoverer.triggerDefaultScan();
        }
    }

    public final void postInitActions() throws AgentStartException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this._log.info((Object)"Autoinventory Commands Server shutting down");
        ScanManager scanManager = this._scanManager;
        synchronized (scanManager) {
            this._scanManager.shutdown(3000L);
        }
        try {
            this.aiSendReportExecutorService.shutdownNow();
            this.aiSendReportExecutorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this._log.error((Object)"AiSendReportExecutorService did not terminate in a timely manner", (Throwable)e);
        }
        this._log.info((Object)"Autoinventory Commands Server shut down");
    }

    public void refreshOnPluginsChange() {
        this._log.info((Object)"Agent commands refreshOnPluginsChange");
    }

    public void scanComplete(ScanState scanState) throws AutoinventoryException, SystemException {
        if (this._lastCompletedAiScanState != null) {
            try {
                if (!scanState.isSyncScan() && this._lastCompletedAiScanState.isSameState(scanState)) {
                    this._log.debug((Object)"Default scan didn't find any changes, not sending report to the server");
                    return;
                }
            }
            catch (AutoinventoryException e) {
                this._log.error((Object)("Error comparing default scan states: " + (Object)((Object)e)), (Throwable)e);
            }
        }
        this._lastCompletedAiScanState = scanState;
        this._aiCommandsService.setMostRecentState(scanState);
        AIPlatformValue aiPlatformValue = scanState.getPlatform();
        if (aiPlatformValue == null) {
            try {
                ByteArrayOutputStream errInfo = new ByteArrayOutputStream();
                PrintStream errInfoPS = new PrintStream(errInfo);
                scanState.printFullStatus(errInfoPS);
                this._log.warn((Object)("AICommandsServer: scan completed, but we could not even detect the platform, so nothing will be reported to the server.  Here is some information about the error that occurred: \n" + errInfo.toString() + "\n"));
            }
            catch (Exception e) {
                this._log.warn((Object)("AICommandsServer: scan completed, but we could not even detect the platform, so nothing will be reported to the server.  More information would be provided, but this error occurred just trying to generate more information about the error: " + e), (Throwable)e);
            }
            return;
        }
        this.applyAutoApproval(aiPlatformValue);
        scanState.setCertDN(this._certDN);
        this.sendAiSendReportToServer(scanState);
    }

    private void sendAiSendReportToServer(ScanState scanState) {
        if (this.aiSendReportFuture != null && !this.aiSendReportFuture.isDone()) {
            this._log.info((Object)"Cancel current sending as there is another thread to send a newer status to server.");
            this.aiSendReportFuture.cancel(true);
        }
        this.aiSendReportFuture = this.aiSendReportExecutorService.submit(new AiSendReportThread(scanState));
    }

    private void scheduleDefaultScan(boolean isSyncScan) {
        ScanConfiguration scanConfig = new ScanConfiguration();
        scanConfig.setIsDefaultScan(true);
        scanConfig.setIsSyncScan(isSyncScan);
        this._log.debug((Object)("Scheduling DefaultScan..." + (isSyncScan ? "(sync)" : "")));
        this._aiCommandsService.startScan(scanConfig);
    }

    protected void scheduleDefaultSyncScan() {
        this.scheduleDefaultScan(true);
    }

    protected void scheduleDefaultScan() {
        this.scheduleDefaultScan(false);
    }

    private AgentRemoteValue dispatchCommand_internal(String cmd, AgentRemoteValue args) throws AgentRemoteException {
        this._scanManager.interruptHangingScan();
        if (cmd.equals("autoinv:startScan")) {
            try {
                ScanConfigurationCore scanConfig = ScanConfigurationCore.fromAgentRemoteValue((String)"scanConfig", (AgentRemoteValue)args);
                this._aiCommandsService.startScan(scanConfig, false);
            }
            catch (Exception e) {
                this._log.error((Object)"Error starting scan.", (Throwable)e);
                throw new AgentRemoteException("Error starting scan: " + e.toString());
            }
            return null;
        }
        if (cmd.equals("autoinv:stopScan")) {
            this._aiCommandsService.stopScan();
            return null;
        }
        if (cmd.equals("autoinv:getScanStatus")) {
            AgentRemoteValue rval = new AgentRemoteValue();
            ScanStateCore state = this._aiCommandsService.getScanStatus(false);
            try {
                state.toAgentRemoteValue("scanState", rval);
            }
            catch (Exception e) {
                this._log.error((Object)"Error getting scan state.", (Throwable)e);
                throw new AgentRemoteException("Error getting scan status: " + e.toString());
            }
            return rval;
        }
        if (cmd.equals("autoinv:pushRuntimeDiscoveryConfig")) {
            this._aiCommandsService.pushRuntimeDiscoveryConfig(args, false);
            return null;
        }
        throw new AgentRemoteException("Unknown command: " + cmd);
    }

    private AutoinventoryCallbackClient setupClient(AgentConfig agentConfig) {
        StorageProviderFetcher fetcher = new StorageProviderFetcher(this._storage);
        return new AutoinventoryCallbackClient((ProviderFetcher)fetcher, agentConfig);
    }

    private void applyAutoApproval(AIPlatformValue aiPlatformValue) {
        if (!this._autoApproveConfig.exists()) {
            return;
        }
        boolean approvePlatform = this._autoApproveConfig.isAutoApproved("platform");
        aiPlatformValue.setAutoApprove(approvePlatform);
        AIServerValue[] aiServerValues = aiPlatformValue.getAIServerValues();
        if (aiServerValues != null) {
            for (AIServerValue aiServerValue : aiServerValues) {
                boolean approveServer = this._autoApproveConfig.isAutoApproved(aiServerValue.getName());
                this._log.info((Object)("--- Auto-Approve for Server: [" + aiServerValue.getName() + "] is: " + approveServer));
                aiServerValue.setAutoApprove(approveServer);
            }
        }
    }

    private class AiSendReportThread
    extends Thread {
        private ScanState scanState;

        public AiSendReportThread(ScanState scanState) {
            this.scanState = scanState;
        }

        @Override
        public void run() {
            long sleepWaitMillis = 15000L;
            long firstTryTime = System.currentTimeMillis();
            while (!Thread.currentThread().isInterrupted() && this.scanState == AutoinventoryCommandsServer.this._lastCompletedAiScanState) {
                try {
                    if (AutoinventoryCommandsServer.this._log.isDebugEnabled()) {
                        AutoinventoryCommandsServer.this._log.debug((Object)("Sending autoinventory report to server: " + this.scanState));
                    }
                    AutoinventoryCommandsServer.this._client.aiSendReport(this.scanState);
                    AutoinventoryCommandsServer.this._log.info((Object)"Autoinventory report successfully sent to server.");
                    return;
                }
                catch (Exception e) {
                    String eMsg;
                    long diffTime = System.currentTimeMillis() - firstTryTime;
                    if (diffTime > 2592000000L) {
                        eMsg = "Unable to send autoinventory platform data to server for maximum time of " + StringUtil.formatDuration((long)2592000000L) + ", giving up.  Error was: " + e.getMessage();
                        if (AutoinventoryCommandsServer.this._log.isDebugEnabled()) {
                            AutoinventoryCommandsServer.this._log.debug((Object)eMsg, (Throwable)e);
                        } else {
                            AutoinventoryCommandsServer.this._log.error((Object)eMsg);
                        }
                        return;
                    }
                    eMsg = "Unable to send autoinventory platform data to server, waiting for " + String.valueOf(sleepWaitMillis / 1000L) + " seconds before " + "retrying.  Error: " + e.getMessage();
                    if (AutoinventoryCommandsServer.this._log.isDebugEnabled()) {
                        AutoinventoryCommandsServer.this._log.debug((Object)eMsg, (Throwable)e);
                    } else {
                        AutoinventoryCommandsServer.this._log.error((Object)eMsg);
                    }
                    try {
                        Thread.sleep(sleepWaitMillis);
                        if ((sleepWaitMillis += sleepWaitMillis / 2L) <= 3600000L) continue;
                        sleepWaitMillis = 3600000L;
                    }
                    catch (InterruptedException ie) {
                        break;
                    }
                }
            }
            AutoinventoryCommandsServer.this._log.info((Object)("There is a newer scan status for the server. Quitting on: " + this.scanState));
        }
    }
}

