/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.autoinventory.CompositeRuntimeResourceReport;
import org.hyperic.hq.autoinventory.agent.server.RuntimeReportFilter;
import org.hyperic.hq.product.RuntimeResourceReport;

public class RegexRuntimeReportFilter
implements RuntimeReportFilter {
    private static Log log = LogFactory.getLog((String)RegexRuntimeReportFilter.class.getName());
    AgentDaemon agent = null;
    private final String REGEXRUNTIMEFILTER = "regexruntimereportfilter";
    private final String RESOURCETYPESTRING = "resourcetype";
    private final String RESOURCENAMESTRING = "resourcename";
    private Pattern resourceTypePattern = null;
    private Pattern resourceNamePattern = null;

    public CompositeRuntimeResourceReport filterReport(CompositeRuntimeResourceReport r) {
        log.info((Object)"Starting RegexRuntimeReportFilter");
        this.agent = AgentDaemon.getMainInstance();
        Properties p = this.agent.getBootConfig().getBootProperties();
        String resourceTypeString = p.getProperty("regexruntimereportfilter.resourcetype");
        String resourceNameString = p.getProperty("regexruntimereportfilter.resourcename");
        if (null != resourceTypeString || null != resourceNameString) {
            RuntimeResourceReport[] _serverReports = r.getServerReports();
            ArrayList<RuntimeResourceReport> newServerReports = new ArrayList<RuntimeResourceReport>();
            if (resourceTypeString != null) {
                this.resourceTypePattern = Pattern.compile(resourceTypeString);
            }
            if (resourceNameString != null) {
                this.resourceNamePattern = Pattern.compile(resourceNameString);
            }
            ArrayList<RuntimeResourceReport> reportArray = new ArrayList<RuntimeResourceReport>(Arrays.asList(_serverReports));
            for (RuntimeResourceReport report : reportArray) {
                AIPlatformValue[] platforms = report.getAIPlatforms();
                ArrayList<AIPlatformValue> pArray = new ArrayList<AIPlatformValue>(Arrays.asList(platforms));
                for (AIPlatformValue platform : pArray) {
                    AIServerValue[] servers = platform.getAIServerValues();
                    if (servers == null || servers.length == 0) continue;
                    ArrayList<AIServerValue> serverArray = new ArrayList<AIServerValue>(Arrays.asList(servers));
                    Iterator serverIterator = serverArray.iterator();
                    while (serverIterator.hasNext()) {
                        AIServerExtValue server = (AIServerExtValue)serverIterator.next();
                        if (this.isResourceNameMatch(server.getName()) || this.isResourceTypeMatch(server.getServerTypeName())) {
                            log.debug((Object)("Skipping auto discovered Server because it matched regex. " + server.getName()));
                            serverIterator.remove();
                            continue;
                        }
                        ArrayList serviceArray = new ArrayList(server.getAIServiceValuesAsList());
                        Iterator serviceIterator = serviceArray.iterator();
                        while (serviceIterator.hasNext()) {
                            AIServiceValue service = (AIServiceValue)serviceIterator.next();
                            if (!this.isResourceNameMatch(service.getName()) && !this.isResourceTypeMatch(service.getServiceTypeName())) continue;
                            log.info((Object)("Skipping auto discovered Service because it matched regex. " + service.getName()));
                            serviceIterator.remove();
                        }
                        server.setAIServiceValues(serviceArray.toArray(new AIServiceValue[serviceArray.size()]));
                        platform.updateAIServerValue((AIServerValue)server);
                    }
                }
                report.setAIPlatforms(pArray.toArray(new AIPlatformValue[pArray.size()]));
                newServerReports.add(report);
            }
            r.setServerReports(newServerReports.toArray(new RuntimeResourceReport[newServerReports.size()]));
            return r;
        }
        return r;
    }

    boolean isResourceTypeMatch(String type) {
        if (this.resourceTypePattern != null) {
            return this.isMatch(this.resourceTypePattern, type);
        }
        return false;
    }

    boolean isResourceNameMatch(String type) {
        if (this.resourceNamePattern != null) {
            return this.isMatch(this.resourceNamePattern, type);
        }
        return false;
    }

    boolean isMatch(Pattern pattern, String string) {
        if (null == pattern || null == string) {
            return false;
        }
        try {
            Matcher matcher = pattern.matcher(string);
            return matcher.find();
        }
        catch (Exception e) {
            log.debug((Object)("Exception matching response: " + e.getMessage()), (Throwable)e);
            return false;
        }
    }
}

