/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.util;

import org.springframework.roo.support.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlElementBuilder {
    private Element element;

    public XmlElementBuilder(String name, Document document) {
        Assert.hasText(name, "Element name required.");
        Assert.notNull(document, "Owner document required");
        this.element = document.createElement(name);
    }

    public XmlElementBuilder addAttribute(String qName, String value) {
        Assert.hasText(qName, "Attribute qName required.");
        Assert.notNull(value, "Attribute value required.");
        this.element.setAttribute(qName, value);
        return this;
    }

    public XmlElementBuilder addChild(Node node) {
        Assert.notNull(node, "Node required.");
        this.element.appendChild(node);
        return this;
    }

    public XmlElementBuilder setText(String text) {
        Assert.hasText(text, "Text content required.");
        this.element.setTextContent(text);
        return this;
    }

    public Element build() {
        return this.element;
    }
}

