/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.support.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.springframework.roo.support.util.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XmlUtils {
    private static final Map<String, XPathExpression> compiledExpressionCache = new HashMap<String, XPathExpression>();
    private static final XPath xpath = XPathFactory.newInstance().newXPath();
    private static final TransformerFactory transformerFactory = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();

    public static final void writeXml(OutputStream outputEntry, Document document) {
        XmlUtils.writeXml(XmlUtils.createIndentingTransformer(), outputEntry, document);
    }

    public static final void writeMalformedXml(OutputStream outputEntry, NodeList nodes) {
        XmlUtils.writeMalformedXml(XmlUtils.createIndentingTransformer(), outputEntry, nodes);
    }

    public static final void writeXml(Transformer transformer, OutputStream outputEntry, Document document) {
        Assert.notNull(transformer, "Transformer required");
        Assert.notNull(outputEntry, "Output entry required");
        Assert.notNull(document, "Document required");
        transformer.setOutputProperty("method", "xml");
        try {
            transformer.transform(new DOMSource(document), XmlUtils.createUnixStreamResultForEntry(outputEntry));
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public static final void writeMalformedXml(Transformer transformer, OutputStream outputEntry, NodeList nodes) {
        Assert.notNull(transformer, "Transformer required");
        Assert.notNull(outputEntry, "Output entry required");
        Assert.notNull(nodes, "NodeList required");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            for (int i = 0; i < nodes.getLength(); ++i) {
                transformer.transform(new DOMSource(nodes.item(i)), XmlUtils.createUnixStreamResultForEntry(outputEntry));
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private static StreamResult createUnixStreamResultForEntry(OutputStream outputEntry) throws UnsupportedEncodingException {
        OutputStreamWriter writer = System.getProperty("line.separator").equals("\r\n") ? new OutputStreamWriter(outputEntry, "ISO-8859-1"){

            public void write(char[] cbuf, int off, int len) throws IOException {
                for (int i = off; i < off + len; ++i) {
                    if (cbuf[i] == '\r' && (i >= cbuf.length - 1 || cbuf[i + 1] == '\n')) continue;
                    super.write(cbuf[i]);
                }
            }

            public void write(int c) throws IOException {
                if (c != 13) {
                    super.write(c);
                }
            }

            public void write(String str, int off, int len) throws IOException {
                String orig = str.substring(off, off + len);
                String filtered = orig.replace("\r\n", "\n");
                int lengthDiff = orig.length() - filtered.length();
                if (filtered.endsWith("\r")) {
                    super.write(filtered.substring(0, filtered.length() - 1), 0, len - lengthDiff - 1);
                } else {
                    super.write(filtered, 0, len - lengthDiff);
                }
            }
        } : new OutputStreamWriter(outputEntry, "ISO-8859-1");
        return new StreamResult(writer);
    }

    public static Element findFirstElement(String xPathExpression, Element root) {
        if (xPathExpression == null || root == null || xPathExpression.length() == 0) {
            throw new IllegalArgumentException("Xpath expression and root element required");
        }
        Element rootElement = null;
        try {
            XPathExpression expr = compiledExpressionCache.get(xPathExpression);
            if (expr == null) {
                expr = xpath.compile(xPathExpression);
                compiledExpressionCache.put(xPathExpression, expr);
            }
            rootElement = (Element)expr.evaluate(root, XPathConstants.NODE);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Unable evaluate xpath expression", e);
        }
        return rootElement;
    }

    public static Element findFirstElementByName(String name, Element root) {
        Assert.hasText(name, "Element name required");
        Assert.notNull(root, "Root element required");
        return (Element)root.getElementsByTagName(name).item(0);
    }

    public static Element findRequiredElement(String xPathExpression, Element root) {
        Assert.hasText(xPathExpression, "XPath expression required");
        Assert.notNull(root, "Root element required");
        Element element = XmlUtils.findFirstElement(xPathExpression, root);
        Assert.notNull(element, "Unable to obtain required element '" + xPathExpression + "' from element '" + root + "'");
        return element;
    }

    public static List<Element> findElements(String xPathExpression, Element root) {
        ArrayList<Element> elements = new ArrayList<Element>();
        NodeList nodes = null;
        try {
            XPathExpression expr = xpath.compile(xPathExpression);
            nodes = (NodeList)expr.evaluate(root, XPathConstants.NODESET);
        }
        catch (XPathExpressionException e) {
            throw new IllegalArgumentException("Unable evaluate xpath expression", e);
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            elements.add((Element)nodes.item(i));
        }
        return elements;
    }

    public static final Transformer createIndentingTransformer() {
        Transformer xformer;
        try {
            xformer = transformerFactory.newTransformer();
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
        xformer.setOutputProperty("indent", "yes");
        xformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        return xformer;
    }

    public static final DocumentBuilder getDocumentBuilder() {
        try {
            return factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

