/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.windows;

import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.windows.WToolkit;
import sun.java2d.opengl.WGLGraphicsConfig;

public class WindowsFlags {
    private static boolean gdiBlitEnabled;
    private static boolean d3dEnabled;
    private static boolean d3dVerbose;
    private static boolean d3dSet;
    private static boolean d3dOnScreenEnabled;
    private static boolean oglEnabled;
    private static boolean oglVerbose;
    private static boolean offscreenSharingEnabled;
    private static boolean accelReset;
    private static boolean checkRegistry;
    private static boolean disableRegistry;
    private static boolean magPresent;
    private static boolean setHighDPIAware;
    private static float autoScalingThreshold;
    private static boolean autoScaling;
    private static String javaVersion;
    private static final float DEFAULT_AUTO_SCALING_THRESHOLD = 1.5f;

    private static native boolean initNativeFlags();

    private static native float getScaleY();

    public static void initFlags() {
    }

    private static boolean getBooleanProp(String string, boolean bl) {
        String string2 = System.getProperty(string);
        boolean bl2 = bl;
        if (string2 != null) {
            if (string2.equals("true") || string2.equals("t") || string2.equals("True") || string2.equals("T") || string2.equals("")) {
                bl2 = true;
            } else if (string2.equals("false") || string2.equals("f") || string2.equals("False") || string2.equals("F")) {
                bl2 = false;
            }
        }
        return bl2;
    }

    private static boolean isBooleanPropTrueVerbose(String string) {
        String string2 = System.getProperty(string);
        return string2 != null && (string2.equals("True") || string2.equals("T"));
    }

    private static int getIntProp(String string, int n) {
        String string2 = System.getProperty(string);
        int n2 = n;
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private static boolean getPropertySet(String string) {
        String string2 = System.getProperty(string);
        return string2 != null;
    }

    private static void initJavaFlags() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                magPresent = WindowsFlags.getBooleanProp("javax.accessibility.screen_magnifier_present", false);
                boolean bl = !WindowsFlags.getBooleanProp("sun.java2d.noddraw", magPresent);
                boolean bl2 = WindowsFlags.getBooleanProp("sun.java2d.ddoffscreen", bl);
                d3dEnabled = WindowsFlags.getBooleanProp("sun.java2d.d3d", bl && bl2);
                d3dOnScreenEnabled = WindowsFlags.getBooleanProp("sun.java2d.d3d.onscreen", d3dEnabled);
                oglEnabled = WindowsFlags.getBooleanProp("sun.java2d.opengl", false);
                if (oglEnabled) {
                    oglVerbose = WindowsFlags.isBooleanPropTrueVerbose("sun.java2d.opengl");
                    if (WGLGraphicsConfig.isWGLAvailable()) {
                        d3dEnabled = false;
                    } else {
                        if (oglVerbose) {
                            System.out.println("Could not enable OpenGL pipeline (WGL not available)");
                        }
                        oglEnabled = false;
                    }
                }
                gdiBlitEnabled = WindowsFlags.getBooleanProp("sun.java2d.gdiBlit", true);
                d3dSet = WindowsFlags.getPropertySet("sun.java2d.d3d");
                if (d3dSet) {
                    d3dVerbose = WindowsFlags.isBooleanPropTrueVerbose("sun.java2d.d3d");
                }
                offscreenSharingEnabled = WindowsFlags.getBooleanProp("sun.java2d.offscreenSharing", false);
                accelReset = WindowsFlags.getBooleanProp("sun.java2d.accelReset", false);
                checkRegistry = WindowsFlags.getBooleanProp("sun.java2d.checkRegistry", false);
                disableRegistry = WindowsFlags.getBooleanProp("sun.java2d.disableRegistry", false);
                javaVersion = System.getProperty("java.version");
                if (javaVersion == null) {
                    javaVersion = "default";
                } else {
                    int n = javaVersion.indexOf(45);
                    if (n >= 0) {
                        javaVersion = javaVersion.substring(0, n);
                    }
                }
                String string = System.getProperty("sun.java2d.autoScaleThreshold");
                if (string != null) {
                    try {
                        autoScalingThreshold = Float.parseFloat(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        autoScalingThreshold = 1.5f;
                    }
                } else {
                    autoScalingThreshold = 1.5f;
                }
                String string2 = System.getProperty("sun.java2d.dpiaware");
                float f = WindowsFlags.getScaleY();
                if (string2 != null) {
                    setHighDPIAware = string2.equalsIgnoreCase("true");
                    autoScaling = !setHighDPIAware && !(f < autoScalingThreshold);
                } else {
                    String string3 = System.getProperty("sun.java.launcher", "unknown");
                    autoScaling = !(f < autoScalingThreshold);
                    setHighDPIAware = string3.equalsIgnoreCase("SUN_STANDARD") && !autoScaling;
                }
                return null;
            }
        });
    }

    public static boolean isD3DEnabled() {
        return d3dEnabled;
    }

    public static boolean isD3DSet() {
        return d3dSet;
    }

    public static boolean isD3DOnScreenEnabled() {
        return d3dOnScreenEnabled;
    }

    public static boolean isD3DVerbose() {
        return d3dVerbose;
    }

    public static boolean isGdiBlitEnabled() {
        return gdiBlitEnabled;
    }

    public static boolean isTranslucentAccelerationEnabled() {
        return d3dEnabled;
    }

    public static boolean isOffscreenSharingEnabled() {
        return offscreenSharingEnabled;
    }

    public static boolean isMagPresent() {
        return magPresent;
    }

    public static boolean isOGLEnabled() {
        return oglEnabled;
    }

    public static boolean isOGLVerbose() {
        return oglVerbose;
    }

    public static boolean isAutoScaling() {
        return autoScaling;
    }

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initJavaFlags();
        WindowsFlags.initNativeFlags();
    }
}

