/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class LogProxy
implements LogAdapter {
    private String name;
    private LogAdapter logger;

    public LogProxy(String name) {
        this.name = name;
    }

    public LogProxy(LogAdapter logger) {
        this.logger = logger;
    }

    public void debug(Object message) {
        if (this.logger != null) {
            this.logger.debug(message);
        }
    }

    public void error(Object message) {
        if (this.logger != null) {
            this.logger.error(message);
        }
    }

    public void error(Object message, Throwable throwable) {
        if (this.logger != null) {
            this.logger.error(message, throwable);
        }
    }

    public void fatal(Object message) {
        if (this.logger != null) {
            this.logger.fatal(message);
        }
    }

    public void fatal(Object message, Throwable throwable) {
        if (this.logger != null) {
            this.logger.fatal(message, throwable);
        }
    }

    public LogLevel getEffectiveLogLevel() {
        if (this.logger != null) {
            return this.logger.getEffectiveLogLevel();
        }
        return LogLevel.OFF;
    }

    public Iterator getLogHandler() {
        if (this.logger != null) {
            return this.logger.getLogHandler();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public LogLevel getLogLevel() {
        if (this.logger != null) {
            return this.logger.getLogLevel();
        }
        return LogLevel.OFF;
    }

    public String getName() {
        if (this.logger != null) {
            this.logger.getName();
        }
        return this.name;
    }

    public void info(Object message) {
        if (this.logger != null) {
            this.logger.info(message);
        }
    }

    public boolean isDebugEnabled() {
        if (this.logger != null) {
            return this.logger.isDebugEnabled();
        }
        return false;
    }

    public boolean isInfoEnabled() {
        if (this.logger != null) {
            return this.logger.isInfoEnabled();
        }
        return false;
    }

    public boolean isWarnEnabled() {
        if (this.logger != null) {
            return this.logger.isWarnEnabled();
        }
        return false;
    }

    public void setLogLevel(LogLevel level) {
        if (this.logger != null) {
            this.logger.setLogLevel(level);
        }
    }

    public void warn(Object message) {
        if (this.logger != null) {
            this.logger.warn(message);
        }
    }

    public LogAdapter getLogger() {
        return this.logger;
    }

    public void setLogger(LogAdapter logger) {
        this.logger = logger;
    }
}

