/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.security;

import java.util.Hashtable;
import java.util.Map;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.smi.Integer32;

public class SecurityModels {
    private Map securityModels = new Hashtable(3);
    private static SecurityModels instance = null;

    protected SecurityModels() {
    }

    public static synchronized SecurityModels getInstance() {
        if (instance == null) {
            instance = new SecurityModels();
        }
        return instance;
    }

    public static final SecurityModels getCollection(SecurityModel[] models) {
        SecurityModels smc = new SecurityModels();
        for (int i = 0; i < models.length; ++i) {
            smc.addSecurityModel(models[i]);
        }
        return smc;
    }

    public void addSecurityModel(SecurityModel model) {
        this.securityModels.put(new Integer32(model.getID()), model);
    }

    public SecurityModel removeSecurityModel(Integer32 id) {
        return (SecurityModel)this.securityModels.remove(id);
    }

    public SecurityModel getSecurityModel(Integer32 id) {
        return (SecurityModel)this.securityModels.get(id);
    }
}

