/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.hqagent;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.hyperic.hq.product.LogTrackPlugin;

public class TrackEventLogAppender
extends AppenderSkeleton {
    private LogTrackPlugin plugin;
    private String source;

    public TrackEventLogAppender(LogTrackPlugin plugin, String source) {
        this.plugin = plugin;
        this.source = source;
        this.setName(plugin.getName());
    }

    public static int toLogTrackLevel(Priority level) {
        switch (level.toInt()) {
            case 40000: 
            case 50000: {
                return 3;
            }
            case 30000: {
                return 4;
            }
            case 20000: {
                return 6;
            }
        }
        return 7;
    }

    protected void append(LoggingEvent event) {
        Priority level = event.level;
        String category = event.categoryName;
        int ix = category.lastIndexOf(".");
        if (ix > -1) {
            category = category.substring(ix + 1);
        }
        this.plugin.reportEvent(event.timeStamp, TrackEventLogAppender.toLogTrackLevel(level), this.source, "[" + category + "]" + " " + event.getMessage().toString());
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }
}

