/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class Transformer<T, R> {
    public Set<R> transformToSet(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet rtn = new HashSet();
        this.transformAndAddToCollection(c, rtn);
        return rtn;
    }

    public List<R> transformToList(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList rtn = new ArrayList();
        this.transformAndAddToCollection(c, rtn);
        return rtn;
    }

    public List<R> transform(Collection<T> c) {
        if (c == null || c.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<R> rtn = new ArrayList<R>(c.size());
        for (T obj : c) {
            R t = this.transform(obj);
            if (t == null) continue;
            rtn.add(t);
        }
        return rtn;
    }

    public abstract R transform(T var1);

    private void transformAndAddToCollection(Collection<T> in, Collection<R> out) {
        for (T obj : in) {
            R t = this.transform(obj);
            if (t == null) continue;
            out.add(t);
        }
    }
}

