/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.hyperic.util.file.TgzUpdater;
import org.hyperic.util.file.ZipUpdater;

public abstract class ArchiveUpdater {
    public static ZipUpdater zipUpdater = new ZipUpdater();
    public static TgzUpdater tgzUpdater = new TgzUpdater();

    public static ArchiveUpdater getUpdater(File f) throws FileNotFoundException {
        if (!f.exists()) {
            throw new FileNotFoundException("Archive does not exist: " + f.getAbsolutePath());
        }
        if (f.getPath().toLowerCase().endsWith(".tgz") || f.getPath().toLowerCase().endsWith(".tar.gz")) {
            return tgzUpdater;
        }
        if (f.getPath().toLowerCase().endsWith(".zip") || f.getPath().toLowerCase().endsWith(".jar")) {
            return zipUpdater;
        }
        throw new IllegalArgumentException("Unrecognized archive: " + f);
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: java " + ArchiveUpdater.class.getName() + " <archive> <dest|SAME> <path> <file>");
            return;
        }
        File archive = new File(args[0]);
        File destFile = ArchiveUpdater.getDestFile(args[1]);
        try {
            ArchiveUpdater updater = ArchiveUpdater.getUpdater(archive);
            updater.update(archive, destFile, args[2], new File(args[3]));
        }
        catch (IOException e) {
            System.err.println("IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(File arch, File out, String pathToReplace, File replacementFile) throws IOException {
        FileInputStream fi = null;
        try {
            fi = new FileInputStream(replacementFile);
            this.update(arch, out, pathToReplace, fi, replacementFile.length());
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public abstract void update(File var1, File var2, String var3, InputStream var4, long var5) throws IOException;

    protected boolean matches(String archPath, String match) {
        if (match.startsWith("**")) {
            return archPath.endsWith(match.substring(2, match.length()));
        }
        return archPath.equals(match);
    }

    protected void doClose(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void doClose(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static File getDestFile(String arg) {
        if (arg.equalsIgnoreCase("SAME")) {
            return null;
        }
        return new File(arg);
    }
}

