/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.jdbc;

import java.sql.SQLException;
import java.util.HashMap;
import org.hyperic.util.ConfigPropertyException;
import org.hyperic.util.jdbc.DBUtil;
import org.hyperic.util.jdbc.IDGenerator;
import org.hyperic.util.jdbc.SequenceRetrievalException;

public class IDGeneratorFactory {
    private static HashMap generatorMap = new HashMap();
    private static int DEFAULT_INTERVAL = 50;

    public static long getNextId(String ctx, String sequenceName, DBUtil dbUtil) throws ConfigPropertyException, SequenceRetrievalException, SQLException {
        IDGenerator theGenerator = IDGeneratorFactory.getGenerator(ctx, sequenceName, dbUtil);
        return theGenerator.getNewID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IDGenerator getGenerator(String ctx, String sequenceName, DBUtil dbUtil) throws ConfigPropertyException, SequenceRetrievalException, SQLException {
        IDGenerator result = null;
        HashMap hashMap = generatorMap;
        synchronized (hashMap) {
            result = (IDGenerator)generatorMap.get(sequenceName);
            if (result == null) {
                result = new IDGenerator(ctx, sequenceName, DEFAULT_INTERVAL, dbUtil);
                generatorMap.put(sequenceName, result);
            }
        }
        return result;
    }
}

