/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.paramParser;

import org.hyperic.util.paramParser.FormatParser;
import org.hyperic.util.paramParser.ParseException;

public class IntervalParser
implements FormatParser {
    private long value;

    @Override
    public void parseValue(String arg) throws ParseException {
        if (arg.length() < 2) {
            throw new ParseException("Malformatted interval, '" + arg + "'");
        }
        String subStr = arg.substring(0, arg.length() - 1);
        try {
            int val = Integer.parseInt(subStr);
        }
        catch (NumberFormatException exc) {
            throw new ParseException("Malformatted interval, '" + arg + "'");
        }
        char c = Character.toLowerCase(arg.charAt(arg.length() - 1));
        switch (c) {
            case 'd': {
                val *= 24;
            }
            case 'h': {
                val *= 60;
            }
            case 'm': {
                val *= 60;
            }
            case 's': {
                break;
            }
            default: {
                throw new ParseException("Unknown interval type '" + c + "'");
            }
        }
        this.value = val *= 1000;
    }

    public long getValue() {
        return this.value;
    }
}

