/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.params.HttpParams;

public class EpopsSslSocketFactory
extends SSLSocketFactory {
    private static final String[] ENABLED_CIPHERS = new String[]{"TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256"};
    private static final List<String> ALL_ENABLED_PROTOCOLS = Collections.unmodifiableList(Arrays.asList("TLSv1", "TLSv1.1", "TLSv1.2"));

    public EpopsSslSocketFactory(TrustStrategy trustStrategy, X509HostnameVerifier hostnameVerifier) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        super(trustStrategy, hostnameVerifier);
    }

    public EpopsSslSocketFactory(SSLContext sslContext, X509HostnameVerifier hostnameVerifier) {
        super(sslContext, hostnameVerifier);
    }

    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        sslSocket.setEnabledCipherSuites(ENABLED_CIPHERS);
        this.setEnabledProtocols(sslSocket);
        return sslSocket;
    }

    public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws UnknownHostException, IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(s, host, port, autoClose);
        sslSocket.setEnabledCipherSuites(ENABLED_CIPHERS);
        this.setEnabledProtocols(sslSocket);
        return sslSocket;
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(params);
        sslSocket.setEnabledCipherSuites(ENABLED_CIPHERS);
        this.setEnabledProtocols(sslSocket);
        return sslSocket;
    }

    protected void setEnabledProtocols(SSLSocket sslSocket) {
        LinkedList<String> enabledProtocols = new LinkedList<String>();
        List<String> supportedProtocols = Arrays.asList(sslSocket.getSupportedProtocols());
        for (String protocol : ALL_ENABLED_PROTOCOLS) {
            if (!supportedProtocols.contains(protocol)) continue;
            enabledProtocols.add(protocol);
        }
        sslSocket.setEnabledProtocols(enabledProtocols.toArray(new String[enabledProtocols.size()]));
    }
}

