/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.operator.OperatorCreationException;
import org.hyperic.util.file.FileUtil;
import org.hyperic.util.security.CertificateService;
import org.hyperic.util.security.KeystoreConfig;

public class KeystoreManager {
    private static final int SLEEP_CYCLE_LENGTH_TO_AWAIT_KEYSTORE = 1000;
    private static final int NUM_SLEEP_CYCLES_TO_AWAIT_KEYSTORE = 20;
    private final AtomicBoolean isDB = new AtomicBoolean(false);
    private static KeystoreManager keystoreManager = new KeystoreManager();
    private static final Log log = LogFactory.getLog(KeystoreManager.class);

    public static KeystoreManager getKeystoreManager() {
        return keystoreManager;
    }

    private String getDName(KeystoreConfig keystoreConfig) {
        return "CN=" + keystoreConfig.getKeyCN() + " (Self-Signed Cert), OU=End Point Operations Management , O=vmware.com, L=Unknown, ST=Unknown, C=US";
    }

    public void initializeKeyStore(KeystoreConfig keystoreConfig) throws KeyStoreException, IOException {
        log.debug((Object)"Initializing keystore");
        this.validateKeystoreConfig(keystoreConfig);
        FileInputStream keyStoreFileInputStream = null;
        String filePath = keystoreConfig.getFilePath();
        char[] password = keystoreConfig.getFilePassword();
        try {
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            File file = new File(filePath);
            if (!file.exists()) {
                if (filePath != null && !filePath.isEmpty() && !keystoreConfig.isHqDefault()) {
                    throw new IOException("User specified keystore [" + filePath + "] does not exist.");
                }
                this.createInternalKeystore(keystoreConfig);
                FileUtil.setReadWriteOnlyByOwner(file);
            } else {
                keyStoreFileInputStream = new FileInputStream(file);
                keystore.load(keyStoreFileInputStream, password);
                if (null == KeystoreManager.fetchPrivateKey(keystoreConfig, keystore)) {
                    this.createInternalKeystore(keystoreConfig);
                }
                log.debug((Object)"Loading existing keystore");
            }
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "The algorithm used to check the integrity of the keystore cannot be found.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (CertificateException e) {
            String errorMsg = "Keystore cannot be loaded. One possibility is that the password is incorrect.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (UnrecoverableEntryException e) {
            String errorMsg = "Keystore entry cannot be recovered.";
            throw new KeyStoreException(errorMsg, e);
        }
        finally {
            if (keyStoreFileInputStream != null) {
                keyStoreFileInputStream.close();
            }
        }
    }

    public KeyStore getKeyStore(KeystoreConfig keystoreConfig) throws KeyStoreException, IOException {
        KeyStore keystore = this.waitForKeystoreFileInitialization(keystoreConfig);
        return keystore;
    }

    private KeyStore waitForKeystoreFileInitialization(KeystoreConfig keystoreConfig) throws KeyStoreException, IOException {
        String filePath = keystoreConfig.getFilePath();
        File keystoreFile = null;
        if (filePath != null) {
            keystoreFile = new File(filePath);
        } else {
            log.warn((Object)"keystoreConfig.getFilePath() == null");
            log.warn((Object)"Keystore File not configured (agent.keystore.path), using a empty keystore");
        }
        int numRetriesLeft = 20;
        try {
            boolean isKeystoreInitialized;
            KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
            do {
                if (isKeystoreInitialized = KeystoreManager.isKeystoreInitialized(keystoreFile, keystore, keystoreConfig)) continue;
                try {
                    log.debug((Object)"Waiting for the keystore to be initialized");
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            } while (--numRetriesLeft > 0 && !isKeystoreInitialized);
            if (!isKeystoreInitialized) {
                throw new KeyStoreException(String.format("The keystore at %s is not initialized. Cannot continue.", filePath));
            }
            log.debug((Object)"Loaded an initialized keystore");
            return keystore;
        }
        catch (NoSuchAlgorithmException e) {
            String errorMsg = "The algorithm used to check the integrity of the keystore cannot be found.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (CertificateException e) {
            String errorMsg = "Keystore cannot be loaded. One possibility is that the password is incorrect.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (UnrecoverableEntryException e) {
            String errorMsg = "Keystore cannot be loaded. One possibility is that the alias defined in property file is incorrect.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (IOException e) {
            String errorMsg = "Keystore cannot be loaded. ";
            throw new KeyStoreException(errorMsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isKeystoreInitialized(File keystoreFile, KeyStore keystore, KeystoreConfig keystoreConfig) throws NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableEntryException, KeyStoreException {
        boolean isKeystoreInitialized = false;
        if (keystoreFile == null) {
            keystore.load(null, null);
            isKeystoreInitialized = true;
        } else if (keystoreFile.exists()) {
            FileInputStream keyStoreFileInputStream = null;
            try {
                keyStoreFileInputStream = new FileInputStream(keystoreFile);
                keystore.load(keyStoreFileInputStream, null);
                KeyStore.Entry privateKeyEntry = KeystoreManager.fetchPrivateKey(keystoreConfig, keystore);
                isKeystoreInitialized = null != privateKeyEntry;
            }
            finally {
                if (keyStoreFileInputStream != null) {
                    keyStoreFileInputStream.close();
                }
            }
        }
        return isKeystoreInitialized;
    }

    private static KeyStore.Entry fetchPrivateKey(KeystoreConfig keystoreConfig, KeyStore keystore) throws NoSuchAlgorithmException, UnrecoverableEntryException, KeyStoreException {
        try {
            return keystore.getEntry(keystoreConfig.getAlias(), new KeyStore.PasswordProtection(keystoreConfig.getFilePassword()));
        }
        catch (IOException e) {
            return null;
        }
    }

    private void validateKeystoreConfig(KeystoreConfig keystoreConfig) throws KeyStoreException {
        if (null == keystoreConfig) {
            throw new KeyStoreException("Received null keystoreConfig");
        }
        String errorMsg = "";
        if (keystoreConfig.getAlias() == null) {
            errorMsg = errorMsg + " alias is null. ";
        }
        if (keystoreConfig.getFilePath() == null) {
            errorMsg = errorMsg + " filePath is null. ";
        }
        try {
            if (keystoreConfig.getFilePassword() == null) {
                errorMsg = errorMsg + " password is null. ";
            }
        }
        catch (IOException e) {
            errorMsg = errorMsg + " couldn't get password. ";
        }
        if (!"".equals(errorMsg)) {
            throw new KeyStoreException(errorMsg);
        }
    }

    private KeyStore createInternalKeystore(KeystoreConfig keystoreConfig) throws KeyStoreException {
        KeyStore keystore;
        try {
            String dName = this.getDName(keystoreConfig);
            keystore = CertificateService.createInternalKeystore(keystoreConfig, dName);
        }
        catch (IOException e) {
            String errorMsg = "Failed to save the keystore.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (OperatorCreationException e) {
            String errorMsg = "Failed to save the keystore.";
            throw new KeyStoreException(errorMsg, e);
        }
        catch (GeneralSecurityException e) {
            String errorMsg = "Failed to save the keystore.";
            throw new KeyStoreException(errorMsg, e);
        }
        return keystore;
    }

    public X509TrustManager getCustomTrustManager(X509TrustManager defaultTrustManager, KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates, KeyStore trustStore) {
        return new CustomTrustManager(defaultTrustManager, keystoreConfig, acceptUnverifiedCertificates, trustStore, this.isDB.get());
    }

    public static X509TrustManager getCustomTrustManager(KeystoreConfig keystoreConfig) throws KeyStoreException, IOException {
        KeystoreManager keystoreMgr = KeystoreManager.getKeystoreManager();
        KeyStore trustStore = keystoreMgr.getKeyStore(keystoreConfig);
        X509TrustManager defaultTrustManager = KeystoreManager.getDefaultTrustManager(trustStore);
        X509TrustManager customTrustManager = keystoreMgr.getCustomTrustManager(defaultTrustManager, keystoreConfig, false, trustStore);
        return customTrustManager;
    }

    public void importServerCert(KeystoreConfig keystoreConfig, X509Certificate x509Certificate) {
        try {
            String serverCertificateAlias = keystoreConfig.getServerCertificateAlias();
            KeyStore trustStore = this.getKeyStore(keystoreConfig);
            CustomTrustManager myCustomTrustManager = new CustomTrustManager(null, keystoreConfig, true, trustStore, false);
            myCustomTrustManager.importServerCertificate(x509Certificate, serverCertificateAlias);
        }
        catch (Exception e) {
            log.error((Object)"Failed to import X509Certificate", (Throwable)e);
        }
    }

    public static X509TrustManager getDefaultTrustManager(KeyStore trustStore) throws KeyStoreException, IOException {
        TrustManagerFactory trustManagerFactory = KeystoreManager.getTrustManagerFactory(trustStore);
        return (X509TrustManager)trustManagerFactory.getTrustManagers()[0];
    }

    private static TrustManagerFactory getTrustManagerFactory(KeyStore keystore) throws KeyStoreException, IOException {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keystore);
            return trustManagerFactory;
        }
        catch (NoSuchAlgorithmException e) {
            log.error((Object)("The algorithm is not supported: " + e), (Throwable)e);
            throw new KeyStoreException(e);
        }
    }

    private class CustomTrustManager
    implements X509TrustManager {
        private final Log log = LogFactory.getLog(X509TrustManager.class);
        private final X509TrustManager defaultTrustManager;
        private final KeystoreConfig keystoreConfig;
        private final boolean acceptUnverifiedCertificates;
        private final KeyStore trustStore;
        private final boolean isDB;

        private CustomTrustManager(X509TrustManager defaultTrustManager, KeystoreConfig keystoreConfig, boolean acceptUnverifiedCertificates, KeyStore trustStore, boolean isDB) {
            this.defaultTrustManager = defaultTrustManager;
            this.keystoreConfig = keystoreConfig;
            this.acceptUnverifiedCertificates = acceptUnverifiedCertificates;
            this.trustStore = trustStore;
            this.isDB = isDB;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return this.defaultTrustManager.getAcceptedIssuers();
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            try {
                this.defaultTrustManager.checkServerTrusted(chain, authType);
                boolean validated = false;
                for (X509Certificate certificate : chain) {
                    this.log.debug((Object)("\tCertificate for: " + certificate.getSubjectDN()));
                    this.log.debug((Object)("\tCertificate issued by: " + certificate.getIssuerDN()));
                    this.log.debug((Object)("\tThe certificate is valid from " + certificate.getNotBefore() + " to " + certificate.getNotAfter()));
                    this.log.debug((Object)("\tCertificate SN# " + certificate.getSerialNumber()));
                    this.log.debug((Object)("\tGenerated with " + certificate.getSigAlgName()));
                    try {
                        certificate.checkValidity();
                        validated = true;
                    }
                    catch (CertificateException e) {
                        Object expiredCertException = this.getCertificateExceptionOfType(e, CertificateExpiredException.class);
                        if (expiredCertException != null) {
                            this.log.error((Object)((Throwable)expiredCertException).getMessage());
                            if (chain.length == 1 && !validated) {
                                throw expiredCertException;
                            }
                            if (chain.length > 1 && !validated) {
                                throw expiredCertException;
                            }
                            this.log.warn((Object)("Skipping the Expired certificate : " + certificate.getIssuerDN()));
                            continue;
                        }
                        throw e;
                    }
                }
            }
            catch (CertificateException e) {
                Object expiredCertException = this.getCertificateExceptionOfType(e, CertificateExpiredException.class);
                if (expiredCertException != null && !this.acceptUnverifiedCertificates) {
                    this.log.error((Object)"Fail the connection because the received certificate is expired. Please update the certificate.", expiredCertException);
                    throw expiredCertException;
                }
                Object notYetValidCertException = this.getCertificateExceptionOfType(e, CertificateNotYetValidException.class);
                if (notYetValidCertException != null && !this.acceptUnverifiedCertificates) {
                    this.log.error((Object)"Fail the connection because the received certificate is not valid yet.", notYetValidCertException);
                    throw notYetValidCertException;
                }
                if (this.acceptUnverifiedCertificates) {
                    this.log.debug((Object)"Allowing the connection. Received certificate was not trusted by keystore, but allowed by property ");
                }
                this.log.warn((Object)"Fail the connection because the received certificate is not trusted");
                this.log.debug((Object)("Fail the connection because the received certificate is not trusted. acceptUnverifiedCertificates=" + this.acceptUnverifiedCertificates), (Throwable)e);
                throw new CertificateException(e);
            }
        }

        private <T extends CertificateException> T getCertificateExceptionOfType(Exception exception, Class<? extends CertificateException> searchedClass) {
            while (exception != null) {
                if (searchedClass.isInstance(exception)) {
                    return (T)((CertificateException)exception);
                }
                exception = (Exception)exception.getCause();
            }
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.defaultTrustManager.checkClientTrusted(chain, authType);
        }

        /*
         * Exception decompiling
         */
        public void importServerCertificate(X509Certificate x509Certificate, String serverCertificateAlias) throws CertificateException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void close(FileOutputStream fos) {
            if (fos == null) {
                return;
            }
            try {
                fos.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

