/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.security.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.util.security.SecurityUtil;
import org.jasypt.encryption.pbe.PBEStringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.config.PBEConfig;
import org.jasypt.salt.SaltGenerator;
import org.springframework.beans.factory.InitializingBean;

public class MarkedStringEncryptor
implements PBEStringEncryptor,
InitializingBean {
    protected PooledPBEStringEncryptor encryptor;
    protected static final String PREFIX = "ENC(";
    protected static final String POSTFIX = ")";
    protected final Log logger = LogFactory.getLog((String)this.getClass().getName());
    private static final int DEFAULT_POOL_SIZE = 1;

    public MarkedStringEncryptor(int poolsize) {
        this.encryptor = new PooledPBEStringEncryptor();
        this.setPoolSize(poolsize);
    }

    public MarkedStringEncryptor() {
        this(1);
    }

    public MarkedStringEncryptor(String algorithm, String password, int poolsize) {
        this(poolsize);
        this.setAlgorithm(algorithm);
        this.setPassword(password);
    }

    public MarkedStringEncryptor(String algorithm, String password) {
        this(algorithm, password, 1);
    }

    public String encrypt(String message) {
        this.logger.debug((Object)("encrypting: " + message));
        if (SecurityUtil.isMarkedEncrypted(message)) {
            this.logger.error((Object)("the following data is already encrypted: '" + message + "'"));
            return message;
        }
        return SecurityUtil.mark(this.encryptor.encrypt(message));
    }

    public String decrypt(String encryptedMessage) {
        this.logger.debug((Object)("decrypting: " + encryptedMessage));
        if (!SecurityUtil.isMarkedEncrypted(encryptedMessage)) {
            this.logger.error((Object)("the following un-encrypted data exists: '" + encryptedMessage + "'"));
            return encryptedMessage;
        }
        return this.encryptor.decrypt(SecurityUtil.unmark(encryptedMessage));
    }

    public void setConfig(PBEConfig config) {
        this.encryptor.setConfig(config);
    }

    public void setAlgorithm(String algorithm) {
        this.encryptor.setAlgorithm(algorithm);
    }

    public void setKeyObtentionIterations(int keyObtentionIterations) {
        this.encryptor.setKeyObtentionIterations(keyObtentionIterations);
    }

    public void setSaltGenerator(SaltGenerator saltGenerator) {
        this.encryptor.setSaltGenerator(saltGenerator);
    }

    public void setProviderName(String providerName) {
        this.encryptor.setProviderName(providerName);
    }

    public void setProvider(Provider provider) {
        this.encryptor.setProvider(provider);
    }

    public void setStringOutputType(String stringOutputType) {
        this.encryptor.setStringOutputType(stringOutputType);
    }

    public boolean isInitialized() {
        return this.encryptor.isInitialized();
    }

    public void initialize() {
        this.encryptor.initialize();
    }

    public final void setPoolSize(int poolSize) {
        this.encryptor.setPoolSize(poolSize);
    }

    public void afterPropertiesSet() throws Exception {
        this.initialize();
    }

    public int hashCode() {
        return this.encryptor.hashCode();
    }

    public boolean equals(Object obj) {
        return this.encryptor.equals(obj);
    }

    public void setPassword(String password) {
        this.encryptor.setPassword(password);
    }

    public String toString() {
        return this.encryptor.toString();
    }
}

