/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.security.SecureRandom;
import java.util.Arrays;
import org.hyperic.util.security.SecuredPbeStringEncryptor;
import org.jasypt.encryption.StringEncryptor;
import org.jasypt.properties.PropertyValueEncryptionUtils;

public class SecurityUtil {
    public static final String ENC_MARK_PREFIX = "ENC(";
    public static final String ENC_MARK_POSTFIX = ")";
    public static final String HIDDEN_VALUE_MASK = "******";
    private static final String VALID_TOKEN_PATTERN = "^[-\\da-fA-F]+$";
    private static final int VALID_TOKEN_LENGTH = 100;
    private static final String INVALID_TOKEN_LENGTH_ERROR = "Invalid token length: ";
    private static final String INVALID_TOKEN_PATTERN_ERROR = "Invalid token format";

    public static String generateRandomToken() {
        SecureRandom r = new SecureRandom();
        long rand1 = r.nextLong();
        while (rand1 == Long.MIN_VALUE) {
            rand1 = r.nextLong();
        }
        rand1 = Math.abs(rand1);
        try {
            Thread.sleep(rand1 % 100L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        long rand2 = r.nextLong();
        return System.currentTimeMillis() + "-" + Math.abs(rand1) + "-" + Math.abs(rand2);
    }

    public static void validateToken(String token) {
        if (null == token) {
            throw new SecurityException("Invalid token length: null");
        }
        int tokenLength = token.length();
        if (tokenLength < 0 || tokenLength > 100) {
            throw new SecurityException(INVALID_TOKEN_LENGTH_ERROR + tokenLength);
        }
        if (!token.matches(VALID_TOKEN_PATTERN)) {
            throw new SecurityException(INVALID_TOKEN_PATTERN_ERROR);
        }
    }

    public static boolean isMarkedEncrypted(String str) {
        if (str == null) {
            return false;
        }
        String uStr = str.toUpperCase();
        return uStr.startsWith(ENC_MARK_PREFIX) && uStr.endsWith(ENC_MARK_POSTFIX);
    }

    public static String unmark(String str) {
        return str.substring(ENC_MARK_PREFIX.length(), str.length() - ENC_MARK_POSTFIX.length());
    }

    public static String unmarkRecursive(String str) {
        while (str.startsWith(ENC_MARK_PREFIX)) {
            str = str.substring(ENC_MARK_PREFIX.length(), str.length() - ENC_MARK_POSTFIX.length());
        }
        return str;
    }

    public static String mark(String str) {
        return ENC_MARK_PREFIX + str + ENC_MARK_POSTFIX;
    }

    public static String encrypt(StringEncryptor encryptor, String data) {
        return PropertyValueEncryptionUtils.encrypt((String)data, (StringEncryptor)encryptor);
    }

    public static String encrypt(char[] encryptionKey, String data) {
        SecuredPbeStringEncryptor encryptor = new SecuredPbeStringEncryptor(encryptionKey);
        return SecurityUtil.encrypt((StringEncryptor)encryptor, data);
    }

    public static String encrypt(char[] encryptionKey, char[] sensitiveData) {
        SecuredPbeStringEncryptor encryptor = new SecuredPbeStringEncryptor(encryptionKey);
        return SecurityUtil.mark(encryptor.encrypt(sensitiveData));
    }

    public static String decryptRecursiveUnmark(StringEncryptor encryptor, String data) {
        return encryptor.decrypt(SecurityUtil.unmarkRecursive(data.trim()));
    }

    public static String decrypt(StringEncryptor encryptor, String data) {
        return PropertyValueEncryptionUtils.decrypt((String)data, (StringEncryptor)encryptor);
    }

    public static String decrypt(char[] encryptionKey, String data) {
        SecuredPbeStringEncryptor encryptor = new SecuredPbeStringEncryptor(encryptionKey);
        return SecurityUtil.decrypt((StringEncryptor)encryptor, data);
    }

    public static void clearSensitiveData(char[] sensitiveData) {
        if (null == sensitiveData) {
            return;
        }
        Arrays.fill(sensitiveData, '\u0000');
    }

    public static void clearSensitiveData(byte[] sensitiveData) {
        if (null == sensitiveData) {
            return;
        }
        Arrays.fill(sensitiveData, (byte)0);
    }
}

