/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.validator;

import org.hyperic.util.validator.GeoValidation;
import org.hyperic.util.validator.InvalidPhoneException;
import org.hyperic.util.validator.InvalidUSPhoneException;

public class PhoneValidation {
    public static void validatePhone(String country, String phone) throws InvalidPhoneException {
        boolean isUSA = GeoValidation.isUSA(country);
        phone = phone.trim();
        int digits = 0;
        boolean onDash = true;
        boolean onDot = true;
        boolean inParen = false;
        boolean onPlus = false;
        boolean sawPlus = false;
        for (int i = 0; i < phone.length(); ++i) {
            char c = phone.charAt(i);
            if (c == '-') {
                if (onDash || i == phone.length() - 1) {
                    throw PhoneValidation.bail(phone);
                }
                onDash = true;
                continue;
            }
            onDash = false;
            if (c == '.') {
                if (onDot || i == phone.length() - 1) {
                    throw PhoneValidation.bail(phone);
                }
                onDot = true;
                continue;
            }
            onDot = false;
            if (Character.isLetter(c)) break;
            if (Character.isDigit(c)) {
                if (onPlus && isUSA && c != '1') {
                    throw PhoneValidation.bail(phone);
                }
                onPlus = false;
                ++digits;
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            if (c == '+') {
                if (i == 0) {
                    onPlus = true;
                    sawPlus = true;
                    continue;
                }
                throw PhoneValidation.bail(phone);
            }
            if (c == '*' || c == '#' || c == '~') {
                if (i != 0 && i != phone.length() - 1) continue;
                throw PhoneValidation.bail(phone);
            }
            if (c == '(') {
                if (inParen || i == phone.length() - 1) {
                    throw PhoneValidation.bail(phone);
                }
                inParen = true;
                continue;
            }
            if (c != ')') break;
            if (inParen) {
                inParen = false;
                continue;
            }
            throw PhoneValidation.bail(phone);
        }
        if (isUSA) {
            int compareDigits;
            int n = compareDigits = sawPlus ? 11 : 10;
            if (digits < compareDigits) {
                throw PhoneValidation.bailUS(phone);
            }
            return;
        }
        if (digits < 6) {
            throw PhoneValidation.bail(phone);
        }
    }

    private static InvalidPhoneException bail(String p) {
        return new InvalidPhoneException(p);
    }

    private static InvalidPhoneException bailUS(String p) {
        return new InvalidUSPhoneException(p);
    }
}

