/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentAPIInfo;
import org.hyperic.hq.agent.AgentAssertionException;
import org.hyperic.hq.agent.AgentCommandsAPI;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.client.AgentCommandsClient;
import org.hyperic.hq.agent.commands.AgentBundle_result;
import org.hyperic.hq.agent.commands.AgentDie_args;
import org.hyperic.hq.agent.commands.AgentDie_result;
import org.hyperic.hq.agent.commands.AgentPing_args;
import org.hyperic.hq.agent.commands.AgentPing_result;
import org.hyperic.hq.agent.commands.AgentRestart_args;
import org.hyperic.hq.agent.commands.AgentRestart_result;
import org.hyperic.hq.agent.commands.AgentUpgrade_args;
import org.hyperic.hq.agent.commands.AgentUpgrade_result;
import org.hyperic.hq.agent.server.AgentCommandsService;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentServerHandler;
import org.hyperic.hq.agent.server.AgentStartException;
import org.hyperic.hq.agent.server.AgentTransportLifecycle;

public class AgentCommandsServer
implements AgentServerHandler {
    private final AgentCommandsAPI verAPI = new AgentCommandsAPI();
    private final Log log = LogFactory.getLog(this.getClass());
    private AgentCommandsService agentCommandsService;

    public AgentCommandsServer() {
        this.log.info((Object)"Agent commands loaded");
    }

    public AgentAPIInfo getAPIInfo() {
        return this.verAPI;
    }

    public String[] getCommandSet() {
        return AgentCommandsAPI.commandSet;
    }

    public AgentRemoteValue dispatchCommand(String cmd, AgentRemoteValue args, InputStream inStream, OutputStream outStream) throws AgentRemoteException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("dispatching cmd=" + cmd));
        }
        if (cmd.equals("agent:ping")) {
            new AgentPing_args(args);
            this.agentCommandsService.ping();
            return new AgentPing_result();
        }
        if (cmd.equals("agent:restart")) {
            new AgentRestart_args(args);
            this.agentCommandsService.restart();
            return new AgentRestart_result();
        }
        if (cmd.equals("agent:upgrade")) {
            String dest;
            AgentUpgrade_args upgradeArgs = new AgentUpgrade_args(args);
            String bundleFile = upgradeArgs.getBundleFile();
            Map props = this.agentCommandsService.upgrade(bundleFile, dest = upgradeArgs.getDestination());
            if (props.isEmpty()) {
                return new AgentRestart_result();
            }
            String version = (String)props.get("version");
            String bundleName = (String)props.get("bundleName");
            return new AgentUpgrade_result(version, bundleName);
        }
        if (cmd.equals("agent:die")) {
            new AgentDie_args(args);
            this.agentCommandsService.die();
            return new AgentDie_result();
        }
        if (cmd.equals("agent:getCurrentAgentBundle")) {
            String currentAgentBundle = this.agentCommandsService.getCurrentAgentBundle();
            return new AgentBundle_result(currentAgentBundle);
        }
        throw new AgentAssertionException("Unknown command '" + cmd + "'");
    }

    public void startup(AgentDaemon agent) throws AgentStartException {
        AgentTransportLifecycle agentTransportLifecycle;
        try {
            agentTransportLifecycle = agent.getAgentTransportLifecycle();
            this.agentCommandsService = new AgentCommandsService(agent);
        }
        catch (Exception e) {
            throw new AgentStartException("Unable to get agent transport lifecycle: " + e.getMessage());
        }
        this.log.info((Object)"Registering Agent Commands Service with Agent Transport");
        try {
            agentTransportLifecycle.registerService(AgentCommandsClient.class, (Object)this.agentCommandsService);
        }
        catch (Exception e) {
            throw new AgentStartException("Failed to register Agent Commands Service.", e);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(System.getProperty("agent.bundle.home")).append(System.getProperty("file.separator")).append("conf").append(System.getProperty("file.separator")).append("wrapper-additional.conf");
        File f = new File(sb.toString());
        if (f.exists()) {
            f.delete();
        }
        this.log.info((Object)"Agent commands started up");
    }

    public final void postInitActions() throws AgentStartException {
    }

    public void shutdown() {
        this.log.info((Object)"Agent commands shut down");
    }

    public void refreshOnPluginsChange() {
        this.log.info((Object)"Agent commands refreshOnPluginsChange");
    }
}

