/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.bizapp.client.MeasurementCallbackClient;
import org.hyperic.hq.measurement.shared.MeasurementConfigEntity;
import org.hyperic.hq.measurement.shared.MeasurementConfigList;
import org.hyperic.hq.product.LogTrackPlugin;
import org.hyperic.util.config.ConfigResponse;

class ConfigPopulateThread
extends Thread {
    private static final long MAX_TIME_TO_SLEEP = 600000L;
    private final MeasurementCallbackClient client;
    private final Log log = LogFactory.getLog((String)ConfigPopulateThread.class.getName());

    ConfigPopulateThread(MeasurementCallbackClient client) {
        this.client = client;
    }

    @Override
    public void run() {
        MeasurementConfigList configs;
        long timeToSleep = 10000L;
        this.log.info((Object)"Starting config populate thread");
        while (true) {
            try {
                configs = this.client.getMeasurementConfigs();
                break;
            }
            catch (Exception exc) {
                this.log.warn((Object)("Unable to get entities for agent: " + exc.getMessage()));
                this.log.warn((Object)("Sleeping for " + timeToSleep / 1000L + " seconds to fetch entities"));
                if ((timeToSleep *= 2L) > 600000L) {
                    timeToSleep = 600000L;
                }
                try {
                    Thread.sleep(timeToSleep);
                }
                catch (InterruptedException exc2) {
                    this.log.warn((Object)"Interrupted ConfigPopulateThread");
                    return;
                }
            }
        }
        MeasurementConfigEntity[] ents = configs.getEntities();
        for (int i = 0; i < ents.length; ++i) {
            try {
                byte[] encConfig = ents[i].getConfig();
                if (encConfig == null || encConfig.length == 0) continue;
                ConfigResponse config = ConfigResponse.decode((byte[])encConfig);
                AppdefEntityID id = new AppdefEntityID(ents[i].getPluginName());
                this.log.info((Object)("Received measurement configuration for " + ents[i].getPluginType() + " '" + ents[i].getPluginName() + "'"));
                if (!LogTrackPlugin.isEnabled((ConfigResponse)config, (int)id.getType())) continue;
                this.log.info((Object)("Creating log track plugin " + ents[i].getPluginName()));
                AgentDaemon.getMainInstance().getLogTrackPluginManager().createPlugin(ents[i].getPluginName(), ents[i].getPluginType(), config);
                continue;
            }
            catch (Exception exc) {
                this.log.error((Object)("Unable to create plugin: " + ents[i].getPluginName() + " '" + ents[i].getPluginType() + "':" + exc.getMessage()), (Throwable)exc);
            }
        }
    }
}

