/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.util.Random;
import org.hyperic.hq.agent.server.AgentStorageProvider;

public class SchedulerOffsetManager {
    private static final String PROP_SCHEDULER_OFFSET_SEED = "agent.scheduler.offset.seed";
    private long offsetSeed;

    public SchedulerOffsetManager(AgentStorageProvider storage) {
        this.offsetSeed = this.getSchedulerOffsetSeed(storage);
    }

    private long getSchedulerOffsetSeed(AgentStorageProvider storage) {
        long offsetSeed;
        String offsetSeedString = storage.getValue(PROP_SCHEDULER_OFFSET_SEED);
        if (offsetSeedString != null) {
            offsetSeed = Long.parseLong(offsetSeedString);
        } else {
            Random rand = new Random();
            offsetSeed = Math.abs(rand.nextLong());
            storage.setValue(PROP_SCHEDULER_OFFSET_SEED, Long.toString(offsetSeed));
        }
        return offsetSeed;
    }

    public long getSchedluerOffsetForInterval(long interval) {
        long offset = this.offsetSeed % interval;
        offset -= offset % 60000L;
        return offset;
    }
}

