/*
 * Decompiled with CFR 0.152.
 */
package mx4j.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import mx4j.ImplementationException;
import mx4j.server.MBeanInvoker;
import mx4j.server.MBeanMetaData;
import mx4j.util.Utils;

public class ReflectionMBeanInvoker
implements MBeanInvoker {
    protected static final String[] EMPTY_PARAMS = new String[0];
    protected static final Object[] EMPTY_ARGS = new Object[0];

    public Object invoke(MBeanMetaData metadata, String method, String[] params, Object[] args) throws MBeanException, ReflectionException {
        MBeanOperationInfo oper = this.getStandardOperationInfo(metadata, method, params);
        if (oper != null) {
            try {
                return this.doInvoke(metadata, method, params, args);
            }
            catch (BadArgumentException x) {
                throw new RuntimeOperationsException(x.nested);
            }
        }
        throw new ReflectionException(new NoSuchMethodException("Operation " + method + " does not belong to the management interface"));
    }

    public Object getAttribute(MBeanMetaData metadata, String attribute) throws MBeanException, AttributeNotFoundException, ReflectionException {
        MBeanAttributeInfo attr = this.getStandardAttributeInfo(metadata, attribute, false);
        if (attr != null) {
            String methodName = this.getMethodForAttribute(attr, true);
            try {
                return this.doInvoke(metadata, methodName, EMPTY_PARAMS, EMPTY_ARGS);
            }
            catch (BadArgumentException x) {
                throw new ImplementationException();
            }
        }
        throw new AttributeNotFoundException(attribute);
    }

    public void setAttribute(MBeanMetaData metadata, Attribute attribute) throws MBeanException, AttributeNotFoundException, InvalidAttributeValueException, ReflectionException {
        String name = attribute.getName();
        MBeanAttributeInfo attr = this.getStandardAttributeInfo(metadata, name, true);
        if (attr != null) {
            String methodName = this.getMethodForAttribute(attr, false);
            try {
                this.doInvoke(metadata, methodName, new String[]{attr.getType()}, new Object[]{attribute.getValue()});
            }
            catch (BadArgumentException x) {
                throw new InvalidAttributeValueException("Invalid value for attribute " + name + ": " + attribute.getValue());
            }
        } else {
            throw new AttributeNotFoundException(name);
        }
    }

    protected Object doInvoke(MBeanMetaData metadata, String method, String[] signature, Object[] args) throws ReflectionException, MBeanException, BadArgumentException {
        try {
            return this.invokeImpl(metadata, method, signature, args);
        }
        catch (ReflectionException x) {
            throw x;
        }
        catch (MBeanException x) {
            throw x;
        }
        catch (BadArgumentException x) {
            throw x;
        }
        catch (InvocationTargetException x) {
            Throwable t = x.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeErrorException((Error)t);
        }
        catch (Throwable t) {
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t);
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t);
            }
            throw new RuntimeErrorException((Error)t);
        }
    }

    protected Object invokeImpl(MBeanMetaData metadata, String method, String[] signature, Object[] args) throws Throwable {
        Method m = this.getStandardManagementMethod(metadata, method, signature);
        try {
            return m.invoke(metadata.getMBean(), args);
        }
        catch (IllegalAccessException x) {
            throw new ReflectionException(x);
        }
        catch (IllegalArgumentException x) {
            throw new BadArgumentException(x);
        }
    }

    protected MBeanOperationInfo getStandardOperationInfo(MBeanMetaData metadata, String method, String[] signature) {
        MBeanOperationInfo[] opers = metadata.getMBeanInfo().getOperations();
        if (opers != null) {
            for (int i = 0; i < opers.length; ++i) {
                MBeanParameterInfo[] params;
                MBeanOperationInfo oper = opers[i];
                String name = oper.getName();
                if (!method.equals(name) || signature.length != (params = oper.getSignature()).length) continue;
                boolean match = true;
                for (int j = 0; j < params.length; ++j) {
                    MBeanParameterInfo param = params[j];
                    if (signature[j].equals(param.getType())) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                return oper;
            }
        }
        return null;
    }

    protected MBeanAttributeInfo getStandardAttributeInfo(MBeanMetaData metadata, String attribute, boolean forWrite) {
        MBeanAttributeInfo[] attrs = metadata.getMBeanInfo().getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.length; ++i) {
                MBeanAttributeInfo attr = attrs[i];
                String name = attr.getName();
                if (!attribute.equals(name)) continue;
                if (forWrite && attr.isWritable()) {
                    return attr;
                }
                if (forWrite || !attr.isReadable()) continue;
                return attr;
            }
        }
        return null;
    }

    protected String getMethodForAttribute(MBeanAttributeInfo attribute, boolean forRead) {
        String name = attribute.getName();
        String attributeName = null;
        if (forRead) {
            String prefix = attribute.isIs() ? "is" : "get";
            attributeName = prefix + name;
        } else {
            attributeName = "set" + name;
        }
        return attributeName;
    }

    protected Method getStandardManagementMethod(MBeanMetaData metadata, String name, String[] signature) throws ReflectionException {
        try {
            Class[] params = Utils.loadClasses(metadata.getClassLoader(), signature);
            Method method = metadata.getMBeanInterface().getMethod(name, params);
            return method;
        }
        catch (ClassNotFoundException x) {
            throw new ReflectionException(x);
        }
        catch (NoSuchMethodException x) {
            throw new ReflectionException(x);
        }
    }

    private static class BadArgumentException
    extends Exception {
        private final IllegalArgumentException nested;

        private BadArgumentException(IllegalArgumentException nested) {
            this.nested = nested;
        }
    }
}

