/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.plugin.system.LinuxUtils;
import org.hyperic.hq.product.Collector;

public class LinuxCollector
extends Collector {
    private static final Log log = LogFactory.getLog(LinuxCollector.class);
    private final Map<String, DeviceStats> sdpMap = new HashMap<String, DeviceStats>();

    public void collect() {
        log.debug((Object)"[collect]");
        List<String[]> stats = LinuxUtils.getBlockDevicesStats();
        for (String[] fields : stats) {
            String dev = fields[2];
            DeviceStats sdc = new DeviceStats();
            DeviceStats sdp = this.sdpMap.get(dev);
            if (sdp == null) {
                sdp = new DeviceStats();
            }
            double rd_ios = Double.parseDouble(fields[3]);
            double wr_ios = Double.parseDouble(fields[7]);
            double tot_ticks = Double.parseDouble(fields[12]);
            double rq_ticks = Double.parseDouble(fields[13]);
            sdc.nr_ios = rd_ios + wr_ios;
            sdc.rd_sect = Double.parseDouble(fields[4]);
            sdc.wr_sect = Double.parseDouble(fields[9]);
            sdc.rd_ticks = Double.parseDouble(fields[6]);
            sdc.wr_ticks = Double.parseDouble(fields[10]);
            double arqsz = 0.0;
            double await = 0.0;
            if (sdc.nr_ios - sdp.nr_ios != 0.0) {
                arqsz = (sdc.rd_sect - sdp.rd_sect + (sdc.wr_sect - sdp.wr_sect)) / (sdc.nr_ios - sdp.nr_ios);
                await = (sdc.rd_ticks - sdp.rd_ticks + (sdc.wr_ticks - sdp.wr_ticks)) / (sdc.nr_ios - sdp.nr_ios);
            }
            this.setValue(dev + ".tps", sdc.nr_ios);
            this.setValue(dev + ".rd_ios", rd_ios);
            this.setValue(dev + ".wr_ios", wr_ios);
            this.setValue(dev + ".arqsz", arqsz);
            this.setValue(dev + ".await", await);
            this.setValue(dev + ".tot_ticks", tot_ticks);
            this.setValue(dev + ".rq_ticks", rq_ticks / 1000.0);
            this.setValue(dev + ".Availability", 100.0);
            this.sdpMap.put(dev, sdc);
        }
    }

    private class DeviceStats {
        private double nr_ios;
        private double rd_sect;
        private double wr_sect;
        private double rd_ticks;
        private double wr_ticks;

        private DeviceStats() {
        }
    }
}

