/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.appdef.shared.AIServerExtValue;
import org.hyperic.hq.appdef.shared.AIServerValue;
import org.hyperic.hq.appdef.shared.AIServiceValue;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.hq.product.AutoServerDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginManager;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.util.config.ConfigResponse;

public abstract class SystemServerDetector
extends ServerDetector
implements AutoServerDetector,
RuntimeDiscoverer {
    private String name = null;
    private String autoinventoryIdentifier = null;
    private String fqdn;
    private String platformType;
    protected Properties props;
    protected static Log log = LogFactory.getLog((String)"SystemServerDetector");

    protected abstract String getServerType();

    protected abstract ArrayList getSystemServiceValues(Sigar var1, ConfigResponse var2) throws SigarException;

    public void init(PluginManager manager) throws PluginException {
        super.init(manager);
        this.props = manager.getProperties();
    }

    protected String getServerName() {
        if (this.name == null) {
            this.name = "%serviceName%";
        }
        return this.name;
    }

    private String getAutoinventoryIdentifier() {
        if (this.autoinventoryIdentifier == null) {
            this.autoinventoryIdentifier = this.fqdn + " " + this.platformType;
        }
        return this.autoinventoryIdentifier;
    }

    public ServerSignature getServerSignature() {
        return new ServerSignature(this.getServerType(), new String[0], new String[0], new String[0]);
    }

    public void configure(ConfigResponse config) throws PluginException {
        super.configure(config);
        this.fqdn = config.getValue("platform.fqdn");
        this.platformType = config.getValue("platform.type");
    }

    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        ArrayList<AIServerExtValue> servers = new ArrayList<AIServerExtValue>();
        this.configure(platformConfig);
        servers.add(this.getSystemServerValue());
        return servers;
    }

    public RuntimeDiscoverer getRuntimeDiscoverer() {
        return this;
    }

    public RuntimeResourceReport discoverResources(int serverId, AIPlatformValue aiplatform, ConfigResponse config) throws PluginException {
        boolean reportServices;
        this.configure(config);
        AIServiceValue[] services = this.getSystemServiceValues(config);
        if (services == null) {
            return null;
        }
        AIServerExtValue server = this.getSystemServerValue();
        server.setId(new Integer(serverId));
        for (int i = 0; i < services.length; ++i) {
            services[i].setServerId(serverId);
        }
        String prop = "system.services.discover";
        boolean bl = reportServices = !"false".equals(this.getManagerProperty(prop));
        if (services.length != 0) {
            String type = services[0].getServiceTypeName();
            prop = "system." + type + ".discover";
            if ("false".equals(this.getManagerProperty(prop))) {
                reportServices = false;
            }
            if (!reportServices) {
                log.info((Object)("Ignoring " + type + " services."));
            }
        }
        if (reportServices) {
            server.setAIServiceValues(services);
        }
        aiplatform.addAIServerValue((AIServerValue)server);
        RuntimeResourceReport rrr = new RuntimeResourceReport(serverId);
        rrr.addAIPlatform(aiplatform);
        return rrr;
    }

    private AIServerExtValue getSystemServerValue() {
        AIServerExtValue srv = new AIServerExtValue();
        String name = this.getFullServiceName(this.getServerType());
        String ident = this.getFullAutoinventoryIdentifier(this.getServerType());
        srv.setName(name);
        srv.setServerTypeName(this.getServerType());
        srv.setInstallPath("/");
        srv.setAutoinventoryIdentifier(ident);
        srv.setCTime(new Long(System.currentTimeMillis()));
        srv.setProductConfig(ConfigResponse.EMPTY_CONFIG);
        srv.setMeasurementConfig(ConfigResponse.EMPTY_CONFIG);
        srv.setControlConfig(ConfigResponse.EMPTY_CONFIG);
        return srv;
    }

    protected AIServiceValue createSystemService(String type, String name) {
        Long now = new Long(System.currentTimeMillis());
        AIServiceValue svc = new AIServiceValue();
        svc.setServiceTypeName(type);
        svc.setName(name);
        svc.setCTime(now);
        svc.setMTime(now);
        return svc;
    }

    protected AIServiceValue createSystemService(String type, String name, String propName, String propValue) {
        AIServiceValue svc = this.createSystemService(type, name);
        log.debug((Object)("discovered " + name + " [" + type + "]"));
        try {
            ConfigResponse productConfig = new ConfigResponse();
            productConfig.setValue(propName, propValue);
            svc.setProductConfig(productConfig.encode());
            svc.setMeasurementConfig(new ConfigResponse().encode());
        }
        catch (Exception e) {
            log.error((Object)"Unable to encode config");
        }
        return svc;
    }

    protected String getFullServiceName(String name) {
        return name;
    }

    protected String getFullAutoinventoryIdentifier(String name) {
        return this.getAutoinventoryIdentifier() + " " + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AIServiceValue[] getSystemServiceValues(ConfigResponse config) {
        ArrayList services;
        Sigar sigar = new Sigar();
        try {
            services = this.getSystemServiceValues(sigar, config);
        }
        catch (SigarException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            AIServiceValue[] aIServiceValueArray = new AIServiceValue[]{};
            return aIServiceValueArray;
        }
        finally {
            sigar.close();
        }
        if (services == null) {
            return null;
        }
        return services.toArray(new AIServiceValue[0]);
    }
}

