/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.roo.file.monitor.event;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.springframework.roo.support.ant.AntPathMatcher;
import org.springframework.roo.support.ant.PathMatcher;
import org.springframework.roo.support.style.ToStringCreator;
import org.springframework.roo.support.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDetails
implements Comparable<FileDetails> {
    private File file;
    private Long lastModified;
    private static final PathMatcher pathMatcher = new AntPathMatcher();

    public FileDetails(File file, Long lastModified) {
        Assert.notNull((Object)file, (String)"File required");
        this.file = file;
        this.lastModified = lastModified;
    }

    public int hashCode() {
        return 7 * this.file.hashCode() * this.lastModified.hashCode();
    }

    public boolean equals(Object obj) {
        return obj != null && obj instanceof FileDetails && this.compareTo((FileDetails)obj) == 0;
    }

    @Override
    public int compareTo(FileDetails o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int result = o.file.compareTo(this.file);
        if (result == 0) {
            result = o.lastModified.compareTo(this.lastModified);
        }
        return result;
    }

    public String getCanonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot determine canonical path for '" + this.file + "'", ioe);
        }
    }

    public static String getCanonicalPath(File file) {
        Assert.notNull((Object)file, (String)"File required");
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot determine canoncial path for '" + file + "'", ioe);
        }
    }

    public boolean isParentOf(String possibleChildCanonicalPath) {
        Assert.hasText((String)possibleChildCanonicalPath, (String)"Possible child to evaluate is required");
        String parent = this.getCanonicalPath();
        return possibleChildCanonicalPath.startsWith(parent);
    }

    public boolean matchesAntPath(String antPath) {
        Assert.hasText((String)antPath, (String)"Ant path to match required");
        return FileDetails.matchesAntPath(antPath, this.getCanonicalPath());
    }

    public static boolean matchesAntPath(String antPath, String canonicalPath) {
        Assert.hasText((String)antPath, (String)"Ant path to match required");
        Assert.hasText((String)canonicalPath, (String)"Canonical path to match required");
        return pathMatcher.match(antPath, canonicalPath);
    }

    public String getRelativeSegment(String childCanonicalPath) {
        Assert.notNull((Object)childCanonicalPath, (String)"Child identifier is required");
        Assert.isTrue((boolean)this.isParentOf(childCanonicalPath), (String)("Identifier '" + childCanonicalPath + "' is not a child of '" + this + "'"));
        return childCanonicalPath.substring(this.getCanonicalPath().length());
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        ToStringCreator tsc = new ToStringCreator((Object)this);
        tsc.append("file", (Object)this.file);
        tsc.append("exists", this.file.exists());
        tsc.append("lastModified", (Object)(this.lastModified == null ? "Unavailable" : new Date(this.lastModified).toString()));
        return tsc.toString();
    }

    static {
        ((AntPathMatcher)pathMatcher).setPathSeparator(File.separator);
    }
}

