/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.Serializable;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.LatherUtil;
import org.hyperic.hq.autoinventory.ScanMethod;
import org.hyperic.hq.autoinventory.ScanMethodConfig;
import org.hyperic.hq.autoinventory.ServerSignature;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.encoding.Base64;

public class ScanConfigurationCore
implements Serializable {
    private static final long serialVersionUID = -6390296285632945265L;
    private ScanMethodConfig[] _scanConfigs = new ScanMethodConfig[0];
    private ServerSignature[] _serverSigs = new ServerSignature[0];
    private ConfigResponse configResponse;

    public ScanMethodConfig[] getScanMethodConfigs() {
        return this._scanConfigs;
    }

    public void setScanMethodConfigs(ScanMethodConfig[] configs) {
        this._scanConfigs = configs;
    }

    public void addScanMethodConfig(ScanMethod method, ConfigResponse configResponse) {
        ScanMethodConfig config = new ScanMethodConfig();
        config.setMethodClass(method.getClass().getName());
        config.setConfig(configResponse);
        if (this._scanConfigs != null) {
            ScanMethodConfig[] newConfigs = new ScanMethodConfig[this._scanConfigs.length + 1];
            System.arraycopy(this._scanConfigs, 0, newConfigs, 0, this._scanConfigs.length);
            newConfigs[newConfigs.length - 1] = config;
            this._scanConfigs = newConfigs;
        } else {
            this._scanConfigs = new ScanMethodConfig[]{config};
        }
    }

    public void setServerSignatures(ScanMethodConfig[] configs) {
        this._scanConfigs = configs;
    }

    public ServerSignature[] getServerSignatures() {
        return this._serverSigs;
    }

    public void setServerSignatures(ServerSignature[] serverSigs) {
        this._serverSigs = serverSigs;
    }

    public ScanMethodConfig findScanMethodConfig(ScanMethod method) {
        return this.findScanMethodConfig(method.getClass().getName());
    }

    public ScanMethodConfig findScanMethodConfig(String methodClass) {
        if (this._scanConfigs != null) {
            for (int i = 0; i < this._scanConfigs.length; ++i) {
                if (!this._scanConfigs[i].getMethodClass().equals(methodClass)) continue;
                return this._scanConfigs[i];
            }
        }
        throw new IllegalArgumentException("Scan method not found: " + methodClass);
    }

    public byte[] serialize() throws AutoinventoryException {
        return LatherUtil.serialize(this);
    }

    public String encode() throws AutoinventoryException {
        return Base64.encode((byte[])this.serialize());
    }

    public static ScanConfigurationCore deserialize(byte[] data) throws AutoinventoryException {
        return LatherUtil.deserializeScanConfigurationCore(data);
    }

    public static ScanConfigurationCore decode(String data) throws AutoinventoryException {
        return ScanConfigurationCore.deserialize(Base64.decode((String)data));
    }

    public void toAgentRemoteValue(String keyName, AgentRemoteValue arv) throws AutoinventoryException {
        arv.setValue(keyName, Base64.encode((byte[])this.serialize()));
    }

    public static ScanConfigurationCore fromAgentRemoteValue(String keyName, AgentRemoteValue arv) throws AutoinventoryException {
        return ScanConfigurationCore.decode(arv.getValue(keyName));
    }

    public String toString() {
        String scans;
        int i;
        String rstr = "ScanConfiguration: ";
        String stypes = "";
        ServerSignature[] serverSigs = this.getServerSignatures();
        if (serverSigs == null || serverSigs.length == 0) {
            stypes = "NONE";
        } else {
            for (i = 0; i < serverSigs.length; ++i) {
                if (i > 0) {
                    stypes = stypes + ", ";
                }
                stypes = stypes + serverSigs[i].getServerTypeName();
            }
        }
        ScanMethodConfig[] configs = this.getScanMethodConfigs();
        if (configs == null || configs.length == 0) {
            scans = "NONE";
        } else {
            scans = "";
            for (i = 0; i < configs.length; ++i) {
                String methodClass = configs[i].getMethodClass();
                try {
                    ScanMethod method = (ScanMethod)Class.forName(methodClass).newInstance();
                    String methodName = method.getName();
                    scans = scans + "\n\t" + methodName + ": " + configs[i].getConfig();
                    continue;
                }
                catch (Exception e) {
                    scans = scans + "\n\t" + methodClass + ": " + "Error reading config: " + e;
                }
            }
        }
        rstr = rstr + "\n  Global Config:\n  Server Types: " + stypes + "\n  Scan Methods: " + scans + "\nConfigResponse: " + this.configResponse;
        return rstr;
    }

    public boolean equals(Object o) {
        if (o instanceof ScanConfigurationCore) {
            ServerSignature[] ss2;
            int i;
            ScanMethodConfig[] config2;
            ScanConfigurationCore scc = (ScanConfigurationCore)o;
            ScanMethodConfig[] config1 = this.getScanMethodConfigs();
            if (config1.length != (config2 = scc.getScanMethodConfigs()).length) {
                return false;
            }
            for (i = 0; i < config1.length; ++i) {
                if (config1[i].equals(config2[i])) continue;
                return false;
            }
            ServerSignature[] ss1 = this.getServerSignatures();
            if (ss1.length != (ss2 = scc.getServerSignatures()).length) {
                return false;
            }
            for (i = 0; i < ss1.length; ++i) {
                if (ss1[i].equals(ss2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public ConfigResponse getConfigResponse() {
        return this.configResponse;
    }

    public void setConfigResponse(ConfigResponse configResponse) {
        this.configResponse = configResponse;
    }
}

