/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.Serializable;
import java.util.List;
import org.hyperic.util.StringUtil;

public class ServerSignature
implements Serializable {
    private static final long serialVersionUID = 3718280788996349461L;
    private String _stName;
    private String[] _fileMatchPatterns;
    private String[] _fileExcludePatterns;
    private String[] _registryMatchPatterns;
    private static final String[] NO_PATTERNS = new String[0];

    public ServerSignature() {
    }

    public ServerSignature(String name, String[] match, String[] exclude, String[] regMatch) {
        this._stName = name;
        this._fileMatchPatterns = match;
        this._fileExcludePatterns = exclude;
        this._registryMatchPatterns = regMatch;
    }

    public ServerSignature(String name, List match, List exclude, List regMatch) {
        this._stName = name;
        if (match != null) {
            this._fileMatchPatterns = match.toArray(new String[0]);
        }
        if (exclude != null) {
            this._fileExcludePatterns = exclude.toArray(new String[0]);
        }
        if (regMatch != null) {
            this._registryMatchPatterns = regMatch.toArray(new String[0]);
        }
    }

    public String getServerTypeName() {
        return this._stName;
    }

    public void setServerTypeName(String stName) {
        this._stName = stName;
    }

    public String[] getFileMatchPatterns() {
        if (this._fileMatchPatterns == null) {
            return NO_PATTERNS;
        }
        return this._fileMatchPatterns;
    }

    public void setFileMatchPatterns(String[] pats) {
        this._fileMatchPatterns = pats;
    }

    public String[] getFileExcludePatterns() {
        if (this._fileExcludePatterns == null) {
            return NO_PATTERNS;
        }
        return this._fileExcludePatterns;
    }

    public void setFileExcludePatterns(String[] pats) {
        this._fileExcludePatterns = pats;
    }

    public String[] getRegistryMatchPatterns() {
        if (this._registryMatchPatterns == null) {
            return NO_PATTERNS;
        }
        return this._registryMatchPatterns;
    }

    public void setRegistryMatchPatterns(String[] pats) {
        this._registryMatchPatterns = pats;
    }

    public String toString() {
        String rstr = "";
        rstr = rstr + "ServerSignature {stName=" + this._stName + ", match=[" + StringUtil.arrayToString((Object[])this._fileMatchPatterns) + "], exclude=[" + StringUtil.arrayToString((Object[])this._fileExcludePatterns) + "], regMatch=[" + StringUtil.arrayToString((Object[])this._registryMatchPatterns) + "]}";
        return rstr;
    }

    public boolean equals(Object o) {
        if (o instanceof ServerSignature) {
            int i;
            String[] patterns2;
            ServerSignature ss = (ServerSignature)o;
            if (!this.getServerTypeName().equals(ss.getServerTypeName())) {
                return false;
            }
            String[] patterns1 = this.getFileMatchPatterns();
            if (patterns1.length != (patterns2 = ss.getFileMatchPatterns()).length) {
                return false;
            }
            for (i = 0; i < patterns1.length; ++i) {
                if (patterns1[i].equals(patterns2[i])) continue;
                return false;
            }
            patterns1 = this.getFileExcludePatterns();
            if (patterns1.length != (patterns2 = ss.getFileExcludePatterns()).length) {
                return false;
            }
            for (i = 0; i < patterns1.length; ++i) {
                if (patterns1[i].equals(patterns2[i])) continue;
                return false;
            }
            patterns1 = this.getRegistryMatchPatterns();
            if (patterns1.length != (patterns2 = ss.getRegistryMatchPatterns()).length) {
                return false;
            }
            for (i = 0; i < patterns1.length; ++i) {
                if (patterns1[i].equals(patterns2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

