/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.bizapp.shared.lather;

import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.bizapp.shared.lather.AiPlatformLatherValue;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.lather.LatherKeyNotFoundException;
import org.hyperic.lather.LatherRemoteException;
import org.hyperic.lather.LatherValue;

public class RuntimeResourceReportLatherValue
extends LatherValue {
    private static final String PROP_SERVERID = "serverId";
    private static final String PROP_PLATFORM = "platform";

    public RuntimeResourceReportLatherValue() {
    }

    public RuntimeResourceReportLatherValue(RuntimeResourceReport v) {
        this.setIntValue(PROP_SERVERID, v.getServerId());
        if (v.getAIPlatforms() != null) {
            AIPlatformValue[] plats = v.getAIPlatforms();
            for (int i = 0; i < plats.length; ++i) {
                this.addObjectToList(PROP_PLATFORM, (Object)new AiPlatformLatherValue(plats[i]));
            }
        }
    }

    public RuntimeResourceReport getReport() {
        RuntimeResourceReport r = new RuntimeResourceReport();
        r.setServerId(this.getIntValue(PROP_SERVERID));
        try {
            LatherValue[] lPlats = (LatherValue[])this.getObjectList(PROP_PLATFORM);
            AIPlatformValue[] plats = new AIPlatformValue[lPlats.length];
            for (int i = 0; i < plats.length; ++i) {
                plats[i] = ((AiPlatformLatherValue)lPlats[i]).getAIPlatformValue();
            }
            r.setAIPlatforms(plats);
        }
        catch (LatherKeyNotFoundException exc) {
            r.setAIPlatforms(new AIPlatformValue[0]);
        }
        return r;
    }

    public void validate() throws LatherRemoteException {
        try {
            this.getReport();
        }
        catch (LatherKeyNotFoundException exc) {
            throw new LatherRemoteException("All values not set");
        }
    }
}

