/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.pdh;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MetricValue;
import org.hyperic.hq.product.PluginException;
import org.hyperic.sigar.win32.Pdh;
import org.hyperic.sigar.win32.Win32Exception;

public class MultipleCollectQueryPdh {
    private static final String DLLS_PATH_IN_JAR = "priv_lib/";
    private static final String PDH_DLL_NAME = "hyperic_pdh.dll";
    private static final Log log = LogFactory.getLog(MultipleCollectQueryPdh.class);

    private static native long pdhOpenQuery() throws PluginException;

    private static native long pdhAddCounter(long var0, String var2) throws PluginException;

    private static native void pdhRemoveCounter(long var0) throws PluginException;

    private static native void PdhCollectQueryData(long var0) throws PluginException;

    private static native double PdhGetFormattedCounterValue(long var0) throws PluginException;

    private static native String[] pdhGetInstances(String var0) throws PluginException;

    public static String[] getInstances(String path) throws PluginException {
        String[] instances = MultipleCollectQueryPdh.pdhGetInstances(path);
        HashMap<String, InstanceIndex> names = new HashMap<String, InstanceIndex>(instances.length);
        for (int i = 0; i < instances.length; ++i) {
            InstanceIndex ix = (InstanceIndex)names.get(instances[i]);
            if (ix == null) {
                ix = new InstanceIndex();
                names.put(instances[i], ix);
                continue;
            }
            ++ix.index;
            instances[i] = instances[i] + "#" + ix.index;
        }
        return instances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Double> getFormattedValues(List<String> paths) throws PluginException, InterruptedException, Win32Exception {
        HashMap<String, Double> res = new HashMap<String, Double>();
        long q = MultipleCollectQueryPdh.pdhOpenQuery();
        Map<String, Long> counters = MultipleCollectQueryPdh.addCounters(q, paths, res);
        if (!counters.isEmpty()) {
            try {
                MultipleCollectQueryPdh.collectDataTwice(q);
                MultipleCollectQueryPdh.getFormattedCounterValues(paths, counters, res);
            }
            finally {
                MultipleCollectQueryPdh.removeCounters(counters);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getValue(String path) throws PluginException, Win32Exception {
        double res = MetricValue.NONE.getValue();
        long q = MultipleCollectQueryPdh.pdhOpenQuery();
        long counter = MultipleCollectQueryPdh.addCounter(path, q);
        try {
            MultipleCollectQueryPdh.PdhCollectQueryData(q);
            res = MultipleCollectQueryPdh.PdhGetFormattedCounterValue(counter);
        }
        finally {
            MultipleCollectQueryPdh.pdhRemoveCounter(counter);
        }
        return res;
    }

    private static void collectDataTwice(long q) throws PluginException, InterruptedException {
        MultipleCollectQueryPdh.PdhCollectQueryData(q);
        Thread.sleep(1000L);
        MultipleCollectQueryPdh.PdhCollectQueryData(q);
    }

    private static void removeCounters(Map<String, Long> counters) {
        for (Long counter : counters.values()) {
            try {
                MultipleCollectQueryPdh.pdhRemoveCounter(counter);
            }
            catch (PluginException ex) {
                log.debug((Object)"Error removing counters", (Throwable)((Object)ex));
            }
        }
    }

    private static void getFormattedCounterValues(List<String> paths, Map<String, Long> counters, Map<String, Double> res) {
        for (String path : paths) {
            try {
                Long c = counters.get(path);
                if (c == null) continue;
                Double val = MultipleCollectQueryPdh.PdhGetFormattedCounterValue(c);
                log.debug((Object)("formatted path: '" + path + "' value:" + val));
                res.put(path, val);
            }
            catch (PluginException ex) {
                log.debug((Object)("Error getting metric value of path: " + path), (Throwable)((Object)ex));
            }
        }
    }

    private static Map<String, Long> addCounters(long q, List<String> paths, Map<String, Double> res) throws Win32Exception {
        HashMap<String, Long> counters = new HashMap<String, Long>();
        for (String path : paths) {
            try {
                counters.put(path, MultipleCollectQueryPdh.addCounter(path, q));
            }
            catch (PluginException ex) {
                log.debug((Object)("Error adding metric of path: " + path), (Throwable)((Object)ex));
                res.put(path, Double.NaN);
            }
        }
        return counters;
    }

    private static long addCounter(String path, long q) throws PluginException, Win32Exception {
        long counter;
        try {
            counter = MultipleCollectQueryPdh.pdhAddCounter(q, Pdh.translate((String)path));
        }
        catch (Win32Exception e) {
            log.debug((Object)"couldn't add counter. trying again with '/sec' suffix...", (Throwable)e);
            counter = MultipleCollectQueryPdh.pdhAddCounter(q, Pdh.translate((String)(path + "/sec")));
        }
        return counter;
    }

    private static void closeStreams(InputStream inStream, OutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getLibPathInJar() {
        StringBuilder libPathStrBuilder = new StringBuilder();
        libPathStrBuilder.append(DLLS_PATH_IN_JAR);
        String os = System.getProperty("os.arch");
        libPathStrBuilder.append(os.contains("64") ? "x64/" : "win32/");
        libPathStrBuilder.append(PDH_DLL_NAME);
        return libPathStrBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String libPathInJar = MultipleCollectQueryPdh.getLibPathInJar();
        InputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            int length;
            URL in = MultipleCollectQueryPdh.class.getClassLoader().getResource(libPathInJar);
            if (in == null) {
                throw new FileNotFoundException(libPathInJar);
            }
            File out = new File(System.getProperty("java.io.tmpdir"), PDH_DLL_NAME);
            log.info((Object)("[static] Writing dll to: " + out.getAbsolutePath()));
            inStream = in.openStream();
            outStream = new FileOutputStream(out);
            byte[] buffer = new byte[1024];
            while ((length = inStream.read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            MultipleCollectQueryPdh.closeStreams(inStream, outStream);
            System.load(out.getAbsolutePath());
            MultipleCollectQueryPdh.closeStreams(inStream, outStream);
        }
        catch (Exception e) {
            log.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        finally {
            MultipleCollectQueryPdh.closeStreams(inStream, outStream);
        }
    }

    private static final class InstanceIndex {
        long index = 0L;

        private InstanceIndex() {
        }
    }
}

