/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import org.hyperic.hq.product.LogFileTailPlugin;
import org.hyperic.hq.product.TrackEvent;
import org.hyperic.sigar.FileInfo;

public class Log4JLogTrackPlugin
extends LogFileTailPlugin {
    private static final String[] LOG_LEVELS = new String[]{"FATAL,ERROR", "WARN", "INFO", "DEBUG"};

    @Override
    public String[] getLogLevelAliases() {
        return LOG_LEVELS;
    }

    @Override
    public TrackEvent processLine(FileInfo info, String line) {
        Log4JEntry entry = new Log4JEntry();
        if (!entry.parse(line)) {
            return null;
        }
        return this.newTrackEvent(System.currentTimeMillis(), entry.level, info.getName(), entry.message);
    }

    class Log4JEntry {
        String message;
        String level;

        Log4JEntry() {
        }

        public boolean parse(String line) {
            for (String level : Log4JLogTrackPlugin.this.getLogLevelMap().keySet()) {
                int idx = line.indexOf(level);
                if (idx == -1) continue;
                this.level = line.substring(idx, idx + level.length());
                this.message = line;
                return true;
            }
            return false;
        }
    }
}

