/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.DaemonDetector;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.product.ServerResource;
import org.hyperic.hq.product.ServiceResource;
import org.hyperic.snmp.SNMPClient;
import org.hyperic.snmp.SNMPException;
import org.hyperic.snmp.SNMPSession;
import org.hyperic.util.config.ConfigResponse;

public class SNMPDetector
extends DaemonDetector {
    private static final Log log = LogFactory.getLog((String)SNMPDetector.class.getName());
    static final String SNMP_INDEX_NAME = "snmpIndexName";
    static final String SNMP_DESCRIPTION = "snmpDescription";

    @Override
    public List getServerResources(ConfigResponse platformConfig) throws PluginException {
        String indexName = this.getTypeProperty(SNMP_INDEX_NAME);
        if (indexName != null) {
            log.debug((Object)("Looking for servers with " + indexName));
            return this.discoverServices(platformConfig, this.getTypeInfo().getName());
        }
        return super.getServerResources(platformConfig);
    }

    @Override
    protected List discoverServices(ConfigResponse config) throws PluginException {
        return this.discoverServices(config, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List discoverServices(ConfigResponse config, String type) throws PluginException {
        SNMPSession session;
        log.debug((Object)("discoverServices(" + config + ")"));
        String[] keys = this.getCustomPropertiesSchema().getOptionNames();
        ConfigResponse cprops = new ConfigResponse();
        try {
            session = new SNMPClient().getSession(config);
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if (SNMPClient.getOID(key) == null) {
                    log.debug((Object)("Cannot resolve '" + key + "'"));
                    continue;
                }
                try {
                    cprops.setValue(key, session.getSingleValue(key).toString());
                    continue;
                }
                catch (SNMPException e) {
                    log.warn((Object)("Error getting single value '" + key + "': " + e.getMessage()));
                }
            }
            this.setCustomProperties(cprops);
            if (type == null) {
                List i = SNMPDetector.discoverServices(this, config, session);
                return i;
            }
            List i = SNMPDetector.discoverServers(this, config, session, type);
            return i;
        }
        catch (SNMPException e) {
            String msg = "Error discovering services for " + this.getTypeInfo() + ": " + (Object)((Object)e);
            log.error((Object)msg, (Throwable)((Object)e));
            List list = null;
            return list;
        }
        finally {
            session = null;
        }
    }

    public static List discoverServices(ServerDetector plugin, ConfigResponse parentConfig, SNMPSession session) throws PluginException {
        ArrayList services = new ArrayList();
        Map servicePlugins = plugin.getServiceInventoryPlugins();
        if (servicePlugins == null) {
            return services;
        }
        for (Map.Entry entry : servicePlugins.entrySet()) {
            String type = (String)entry.getKey();
            services.addAll(SNMPDetector.discoverServices(plugin, parentConfig, session, type));
        }
        return services;
    }

    public static List discoverServices(ServerDetector plugin, ConfigResponse parentConfig, SNMPSession session, String type) throws PluginException {
        return SNMPDetector.discoverServices(plugin, parentConfig, session, type, true);
    }

    public static List discoverServers(ServerDetector plugin, ConfigResponse parentConfig, SNMPSession session, String type) throws PluginException {
        return SNMPDetector.discoverServices(plugin, parentConfig, session, type, false);
    }

    private static List discoverServices(ServerDetector plugin, ConfigResponse parentConfig, SNMPSession session, String type, boolean isServiceDiscovery) throws PluginException {
        int i;
        List column;
        ArrayList<Object> services = new ArrayList<Object>();
        String typeName = plugin.getTypeNameProperty(type);
        String indexName = plugin.getTypeProperty(type, SNMP_INDEX_NAME);
        String descrName = plugin.getTypeProperty(type, SNMP_DESCRIPTION);
        if (indexName == null) {
            String msg = "No snmpIndexName defined for service autoinventory of " + type;
            log.error((Object)msg);
            return services;
        }
        try {
            column = session.getColumn(indexName);
        }
        catch (SNMPException e) {
            String msg = "Error getting snmpIndexName=" + indexName + ": " + (Object)((Object)e);
            log.error((Object)msg);
            return services;
        }
        log.debug((Object)("Found " + column.size() + " " + type + " services using " + indexName));
        boolean hasDescriptions = false;
        List descriptions = null;
        if (descrName != null) {
            try {
                descriptions = session.getColumn(descrName);
            }
            catch (SNMPException e) {
                String msg = "Error getting snmpDescription=" + descrName + ": " + (Object)((Object)e);
                log.warn((Object)msg);
            }
            if (descriptions != null && descriptions.size() == column.size()) {
                hasDescriptions = true;
            }
        }
        String[] keys = plugin.getCustomPropertiesSchema(type).getOptionNames();
        HashMap<String, List> cpropColumns = new HashMap<String, List>();
        for (i = 0; i < keys.length; ++i) {
            String key = keys[i];
            try {
                cpropColumns.put(key, session.getColumn(key));
                continue;
            }
            catch (SNMPException e) {
                log.warn((Object)("Error getting column '" + key + "': " + e.getMessage()));
            }
        }
        for (i = 0; i < column.size(); ++i) {
            ConfigResponse config = new ConfigResponse();
            ConfigResponse cprops = new ConfigResponse();
            String indexValue = column.get(i).toString().trim();
            String resourceDescr = null;
            config.setValue("snmpIndexValue", indexValue);
            for (int j = 0; j < keys.length; ++j) {
                String key = keys[j];
                List data = (List)cpropColumns.get(key);
                if (data == null || data.isEmpty()) continue;
                String val = data.get(i).toString().trim();
                cprops.setValue(key, val);
            }
            if (hasDescriptions) {
                resourceDescr = descriptions.get(i).toString();
            }
            String resourceName = typeName + " " + indexValue;
            String autoName = plugin.formatAutoInventoryName(type, parentConfig, config, cprops);
            if (isServiceDiscovery) {
                ServiceResource service = new ServiceResource();
                service.setType(type);
                if (autoName == null) {
                    service.setServiceName(resourceName);
                } else {
                    service.setName(autoName);
                }
                service.setProductConfig(config);
                service.setMeasurementConfig();
                service.setCustomProperties(cprops);
                if (resourceDescr != null) {
                    service.setDescription(resourceDescr);
                }
                services.add(service);
                continue;
            }
            ServerResource server = new ServerResource();
            server.setType(type);
            if (autoName == null) {
                server.setName(resourceName);
            } else {
                server.setName(autoName);
            }
            server.setInstallPath("/");
            server.setIdentifier(server.getName());
            server.setProductConfig(config);
            server.setMeasurementConfig();
            server.setCustomProperties(cprops);
            if (resourceDescr != null) {
                server.setDescription(resourceDescr);
            }
            services.add(server);
        }
        return services;
    }
}

