/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.util.encoding.Base64;

public class TrackEvent
implements Serializable {
    public static final int MESSAGE_MAXLEN = 900;
    public static final int SOURCE_MAXLEN = 100;
    private AppdefEntityID id;
    private long time;
    private int level;
    private String source;
    private String message;

    public TrackEvent(AppdefEntityID id, long time, int level, String source, String message) {
        this.id = id;
        this.time = time;
        this.level = level;
        this.source = source;
        this.message = message;
    }

    public TrackEvent(String id, long time, int level, String source, String message) {
        this(new AppdefEntityID(id), time, level, source, message);
    }

    public AppdefEntityID getAppdefId() {
        return this.id;
    }

    public String getSource() {
        return this.source;
    }

    public String getMessage() {
        return this.message;
    }

    public long getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.level;
    }

    private String truncate(String str, int max) {
        if (str == null) {
            return "";
        }
        if (str.length() > max) {
            return str.substring(0, max - 1);
        }
        return str;
    }

    public String encode() throws IOException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        dOs.writeInt(this.id.getID());
        dOs.writeInt(this.id.getType());
        dOs.writeLong(this.time);
        dOs.writeInt(this.level);
        dOs.writeUTF(this.truncate(this.source, 100));
        dOs.writeUTF(this.truncate(this.message, 900));
        return Base64.encode((byte[])bOs.toByteArray());
    }

    public static TrackEvent decode(String data) throws IOException {
        ByteArrayInputStream bIs = new ByteArrayInputStream(Base64.decode((String)data));
        DataInputStream dIs = new DataInputStream(bIs);
        int id = dIs.readInt();
        int type = dIs.readInt();
        long time = dIs.readLong();
        int level = dIs.readInt();
        String source = dIs.readUTF();
        String message = dIs.readUTF();
        return new TrackEvent(new AppdefEntityID(type, id), time, level, source, message);
    }

    public String toString() {
        return this.id + ": msg=" + this.message + " file=" + this.source;
    }
}

